/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8RuntimeException;
import guru.nidi.graphviz.engine.AbstractJavascriptEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.ResultHandler;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V8JavascriptEngine
extends AbstractJavascriptEngine {
    private static final Logger LOG = LoggerFactory.getLogger(V8JavascriptEngine.class);
    private final V8 v8;
    private final ResultHandler resultHandler = new ResultHandler();

    public V8JavascriptEngine() {
        this(null);
    }

    public V8JavascriptEngine(@Nullable String extractionPath) {
        LOG.info("Starting V8 runtime...");
        this.v8 = V8.createV8Runtime(null, (String)extractionPath);
        LOG.info("Started V8 runtime. Initializing javascript...");
        this.v8.registerJavaMethod((receiver, parameters) -> this.resultHandler.setResult(parameters.getString(0)), "result");
        this.v8.registerJavaMethod((receiver, parameters) -> {
            String rawMsg = parameters.getString(0);
            String msg = rawMsg.matches("TypeError: Module\\..*? is not a function") ? "Got Error: '" + rawMsg + "'. This is probably an out of memory error." + " Try using the totalMemory method." : rawMsg;
            this.resultHandler.setError(msg);
        }, "error");
        LOG.info("Initialized javascript.");
    }

    @Override
    protected String execute(String js) {
        try {
            this.v8.executeVoidScript(js);
            return this.resultHandler.waitFor();
        }
        catch (V8RuntimeException e) {
            throw new GraphvizException("Problem executing javascript", e);
        }
    }

    @Override
    public void close() {
        this.v8.release(true);
    }
}

