/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.service;

import guru.nidi.graphviz.service.CommandLineExecutor;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.exec.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRunner {
    private static final Logger LOG = LoggerFactory.getLogger(CommandRunner.class);
    private final Function<CommandLine, CommandLine> wrapperFunc;
    private final CommandLineExecutor cmdExec;

    CommandRunner(Function<CommandLine, CommandLine> wrapperFunc, CommandLineExecutor cmdExec) {
        this.wrapperFunc = wrapperFunc;
        this.cmdExec = cmdExec;
    }

    void exec(String cmd, int timeout, List<String> args) throws IOException, InterruptedException {
        this.exec(cmd, null, timeout, args);
    }

    private void exec(String cmd, @Nullable File workDir, int timeout, List<String> args) throws IOException, InterruptedException {
        this.exec(cmd, workDir, timeout, args.toArray(new String[0]));
    }

    void exec(String cmd, int timeout) throws IOException, InterruptedException {
        this.exec(cmd, null, timeout, new String[0]);
    }

    public void exec(String cmd, @Nullable File workDir, int timeout, String ... args) throws IOException, InterruptedException {
        this.exec(cmd, workDir, args, true, timeout);
    }

    private void exec(String cmd, @Nullable File workDir, String[] args, boolean quote, int timeout) throws IOException, InterruptedException {
        this.exec(new CommandLine(cmd).addArguments(args, quote), workDir, timeout);
    }

    void exec(CommandLine cmd, @Nullable File workDir, int timeout) throws IOException, InterruptedException {
        CommandLine wrappedCmd = this.wrapperFunc.apply(cmd);
        this.cmdExec.execute(wrappedCmd, workDir, timeout);
    }

    static Stream<Path> which(String program) {
        return CommandRunner.which(program, Optional.ofNullable(System.getenv("PATH")).orElse(""));
    }

    private static Stream<Path> which(@Nullable String optProgram, @Nullable String pathEnvVar) {
        if (optProgram == null || "".equals(optProgram.trim()) || pathEnvVar == null || "".equals(pathEnvVar)) {
            return Stream.empty();
        }
        String program = optProgram;
        return Arrays.stream(pathEnvVar.split(File.pathSeparator)).map(SystemUtils::pathOf).filter(path -> Files.exists(path, new LinkOption[0])).map(path -> {
            try (Stream<Path> entries = Files.list(path);){
                Stream stream = entries.filter(filePath -> program.equals(filePath.getFileName().toString())).filter(filePath -> Files.isRegularFile(filePath, new LinkOption[0])).filter(Files::isExecutable).collect(Collectors.toList()).stream();
                return stream;
            }
            catch (IOException e) {
                LOG.error("Problem finding path for {}", (Object)program, (Object)e);
                return Stream.empty();
            }
        }).flatMap(stream -> stream);
    }

    static boolean isExecutableFound(String program) {
        return CommandRunner.which(program).anyMatch(path -> true);
    }

    public static boolean isExecutableFound(String program, String envPath) {
        return CommandRunner.which(program, envPath).anyMatch(path -> true);
    }
}

