/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.validate.Datatype;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class ArrowDatatype
extends Datatype {
    ArrowDatatype() {
        super("arrow");
    }

    @Override
    ValidatorMessage validate(Object value) {
        return new ArrowTypeValidator(value).validate();
    }

    static class ArrowTypeValidator {
        private static final Set<Shape> SHAPES = new HashSet<Shape>(Arrays.asList(new Shape("box", true, true), new Shape("crow", true, false), new Shape("curve", true, false), new Shape("icurve", true, false), new Shape("diamond", true, true), new Shape("dot", false, true), new Shape("inv", true, true), new Shape("none", false, false), new Shape("normal", true, true), new Shape("tee", true, false), new Shape("vee", true, false)));
        private final String s;
        private int pos;

        ArrowTypeValidator(Object value) {
            this.s = value.toString();
            this.pos = 0;
        }

        ValidatorMessage validate() {
            int shapes = 0;
            do {
                ValidatorMessage message;
                if ((message = this.validateShape()) == null) continue;
                return message;
            } while (this.pos < this.s.length() && ++shapes < 4);
            if (this.pos < this.s.length() - 1) {
                return new ValidatorMessage(ValidatorMessage.Severity.ERROR, "More than 4 shapes in '" + this.s + "'.");
            }
            if (shapes > 1 && this.s.endsWith("none")) {
                return new ValidatorMessage(ValidatorMessage.Severity.ERROR, "Last shape cannot be 'none' in '" + this.s + "'.");
            }
            return null;
        }

        private ValidatorMessage validateShape() {
            boolean o = false;
            if (this.pos < this.s.length() && this.s.charAt(this.pos) == 'o') {
                o = true;
                ++this.pos;
            }
            boolean lr = false;
            if (this.pos < this.s.length() && (this.s.charAt(this.pos) == 'l' || this.s.charAt(this.pos) == 'r')) {
                lr = true;
                ++this.pos;
            }
            return this.validateShape(o, lr);
        }

        private ValidatorMessage validateShape(boolean o, boolean lr) {
            Shape shape = this.findShape();
            if (shape == null) {
                return new ValidatorMessage(ValidatorMessage.Severity.ERROR, "Unknown shape '" + this.s.substring(this.pos) + "'.");
            }
            if (o && !shape.o) {
                return new ValidatorMessage(ValidatorMessage.Severity.ERROR, "Shape '" + shape.name + "' is not allowed a 'o' prefix.");
            }
            if (lr && !shape.lr) {
                return new ValidatorMessage(ValidatorMessage.Severity.ERROR, "Shape '" + shape.name + "' is not allowed a 'l'/'r' prefix.");
            }
            return null;
        }

        private Shape findShape() {
            for (Shape shape : SHAPES) {
                if (!this.s.substring(this.pos, Math.min(this.s.length(), this.pos + shape.name.length())).equals(shape.name)) continue;
                this.pos += shape.name.length();
                return shape;
            }
            return null;
        }

        static class Shape {
            final String name;
            final boolean lr;
            final boolean o;

            Shape(String name, boolean lr, boolean o) {
                this.name = name;
                this.lr = lr;
                this.o = o;
            }
        }
    }
}

