/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.attribute.validate.Datatype;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ShapeDatatype
extends Datatype {
    private static final Set<String> NAMES = ShapeDatatype.shapeNames();

    private static Set<String> shapeNames() {
        Set<String> names = Stream.of(Shape.class.getFields()).filter(f -> f.getType() == Shape.class).map(f -> {
            try {
                return (String)((Shape)f.get(null)).value;
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        }).collect(Collectors.toSet());
        names.add("polygon");
        names.add("record");
        names.add("Mrecord");
        return names;
    }

    ShapeDatatype() {
        super("shape");
    }

    @Override
    ValidatorMessage validate(Object value) {
        if (!NAMES.contains(value.toString())) {
            return new ValidatorMessage(ValidatorMessage.Severity.ERROR, "'" + value + "' is not a valid shape.");
        }
        return null;
    }
}

