/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorMessage.class);
    public static final Consumer<ValidatorMessage> LINE_LOGGING_CONSUMER = msg -> LOG.info(String.format("%-5s at %d:%d: '%1.20s' -> %s", new Object[]{msg.severity, msg.line, msg.column, msg.attribute, msg.message}));
    public static final Consumer<ValidatorMessage> POSITION_LOGGING_CONSUMER = msg -> LOG.info(String.format("%-5s %1.20s: '%1.20s' -> %s", new Object[]{msg.severity, msg.position, msg.attribute, msg.message}));
    public static final Consumer<ValidatorMessage> NOP_CONSUMER = msg -> {};
    public final Severity severity;
    public final String attribute;
    public final String message;
    public final int line;
    public final int column;
    public final String position;

    ValidatorMessage(Severity severity, String message) {
        this(severity, "", message);
    }

    public ValidatorMessage(Severity severity, String attribute, String message) {
        this(severity, attribute, message, 0, 0, "");
    }

    public ValidatorMessage(Severity severity, String attribute, String message, int line, int column, String position) {
        this.severity = severity;
        this.attribute = attribute;
        this.message = message;
        this.line = line;
        this.column = column;
        this.position = position;
    }

    public ValidatorMessage at(int line, int column) {
        return new ValidatorMessage(this.severity, this.attribute, this.message, line, column, this.position);
    }

    public ValidatorMessage at(String position) {
        return new ValidatorMessage(this.severity, this.attribute, this.message, this.line, this.column, position);
    }

    ValidatorMessage atAttribute(String attribute) {
        return new ValidatorMessage(this.severity, attribute, this.message, this.line, this.column, this.position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatorMessage that = (ValidatorMessage)o;
        return this.line == that.line && this.column == that.column && this.severity == that.severity && this.attribute.equals(that.attribute) && this.message.equals(that.message) && this.position.equals(that.position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.attribute, this.message, this.line, this.column, this.position});
    }

    public String toString() {
        return (Object)((Object)this.severity) + " " + this.position + (this.line > 0 ? this.line + ":" + this.column : "") + ": '" + this.attribute + "' -> " + this.message;
    }

    public static enum Severity {
        ERROR,
        WARN,
        INFO;

    }
}

