/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.attribute.validate.ValidatorFormat;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.ProcessOptions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Format {
    PNG("svg", "png", true, true){

        @Override
        EngineResult postProcess(Graphviz graphviz, EngineResult result) {
            return result.mapString(s -> Format.postProcessSvg(graphviz.processOptions, s, true));
        }

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.SVG;
        }
    }
    ,
    SVG("svg", "svg", false, true){

        @Override
        EngineResult postProcess(Graphviz graphviz, EngineResult result) {
            return result.mapString(s -> Format.postProcessSvg(graphviz.processOptions, s, true));
        }

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.SVG;
        }
    }
    ,
    SVG_STANDALONE("svg", "svg", false, true){

        @Override
        EngineResult postProcess(Graphviz graphviz, EngineResult result) {
            return result.mapString(s -> Format.postProcessSvg(graphviz.processOptions, s, false));
        }

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.SVG;
        }
    }
    ,
    DOT("dot", "dot"),
    XDOT("xdot", "xdot"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.XDOT;
        }
    }
    ,
    PLAIN("plain", "txt"),
    PLAIN_EXT("plain-ext", "txt"),
    PS("ps", "ps"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.POSTSCRIPT;
        }
    }
    ,
    PS2("ps2", "ps"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.POSTSCRIPT;
        }
    }
    ,
    JSON("json", "json"),
    JSON0("json0", "json"),
    IMAP("imap", "imap"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.MAP;
        }
    }
    ,
    CMAPX("cmapx", "cmapx"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.CMAP;
        }
    };

    private static final Logger LOG;
    private static final Pattern SVG_PATTERN;
    final String vizName;
    public final String fileExtension;
    final boolean image;
    final boolean svg;

    private Format(String vizName, String fileExtension) {
        this(vizName, fileExtension, false, false);
    }

    private Format(String vizName, String fileExtension, boolean image, boolean svg) {
        this.vizName = vizName;
        this.fileExtension = fileExtension;
        this.image = image;
        this.svg = svg;
    }

    String preProcess(String src) {
        return Format.replaceSubSpaces(src);
    }

    EngineResult postProcess(Graphviz graphviz, EngineResult result) {
        return result;
    }

    ValidatorFormat forValidator() {
        return ValidatorFormat.OTHER;
    }

    private static String replaceSubSpaces(String src) {
        char[] chars = src.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= ' ' || chars[i] == '\t' || chars[i] == '\r' || chars[i] == '\n') continue;
            chars[i] = 32;
        }
        return new String(chars);
    }

    private static String postProcessSvg(ProcessOptions options, String result, boolean prefix) {
        String unprefixed = prefix ? Format.withoutPrefix(result) : result;
        return Format.pointsToPixels(unprefixed, options.dpi, options.width, options.height, options.scale);
    }

    private static String withoutPrefix(String svg) {
        int pos = svg.indexOf("<svg ");
        return pos < 0 ? svg : svg.substring(pos);
    }

    private static String pointsToPixels(String svg, double dpi, int width, int height, double scale) {
        Matcher m = SVG_PATTERN.matcher(svg);
        if (!m.find()) {
            LOG.warn("Generated SVG has not the expected format. There might be image size problems.");
            return svg;
        }
        return m.replaceFirst("<svg " + Format.svgSize(m, width, height, scale) + m.group("between") + Format.svgScale(m, dpi));
    }

    private static String svgSize(Matcher m, int width, int height, double scale) {
        double w = Integer.parseInt(m.group("width"));
        double h = Integer.parseInt(m.group("height"));
        if (width > 0 && height > 0) {
            w = width;
            h = height;
        } else if (width > 0) {
            h *= (double)width / w;
            w = width;
        } else if (height > 0) {
            w *= (double)height / h;
            h = height;
        }
        return "width=\"" + Math.round(w * scale) + "px\" height=\"" + Math.round(h * scale) + "px\"";
    }

    private static String svgScale(Matcher m, double dpi) {
        double pixelScale = m.group("unit").equals("px") ? 1.0 : (double)Math.round(10000.0 * dpi / 72.0) / 10000.0;
        double scaleX = Double.parseDouble(m.group("scaleX")) / pixelScale;
        double scaleY = Double.parseDouble(m.group("scaleY")) / pixelScale;
        return "transform=\"scale(" + scaleX + " " + scaleY + ")";
    }

    static {
        LOG = LoggerFactory.getLogger(Format.class);
        SVG_PATTERN = Pattern.compile("<svg width=\"(?<width>\\d+)(?<unit>p[tx])\" height=\"(?<height>\\d+)p[tx]\"(?<between>.*?>\\R<g.*?)transform=\"scale\\((?<scaleX>[0-9.]+) (?<scaleY>[0-9.]+)\\)", 32);
    }
}

