/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.parse;

import guru.nidi.graphviz.attribute.validate.AttributeValidator;
import guru.nidi.graphviz.attribute.validate.ValidatorEngine;
import guru.nidi.graphviz.attribute.validate.ValidatorFormat;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.parse.Lexer;
import guru.nidi.graphviz.parse.ParserImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public final class Parser {
    private final ValidatorEngine engine;
    private final ValidatorFormat format;
    private final Consumer<ValidatorMessage> messageConsumer;

    public Parser() {
        this(ValidatorEngine.UNKNOWN_ENGINE, ValidatorFormat.UNKNOWN_FORMAT, ValidatorMessage.LINE_LOGGING_CONSUMER);
    }

    private Parser(ValidatorEngine engine, ValidatorFormat format, Consumer<ValidatorMessage> messageConsumer) {
        this.engine = engine;
        this.format = format;
        this.messageConsumer = messageConsumer;
    }

    public Parser forEngine(ValidatorEngine engine) {
        return new Parser(engine, this.format, this.messageConsumer);
    }

    public Parser forFormat(ValidatorFormat format) {
        return new Parser(this.engine, format, this.messageConsumer);
    }

    public Parser messageConsumer(Consumer<ValidatorMessage> messageConsumer) {
        return new Parser(this.engine, this.format, messageConsumer);
    }

    public MutableGraph read(File file) throws IOException {
        return this.read(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), file.getName());
    }

    public MutableGraph read(InputStream is) throws IOException {
        return this.read(new InputStreamReader(is, StandardCharsets.UTF_8), "<input stream>");
    }

    public MutableGraph read(String dot) throws IOException {
        return this.read(new StringReader(dot), "<string>");
    }

    public MutableGraph read(Reader dot, String name) throws IOException {
        AttributeValidator validator = new AttributeValidator().forEngine(this.engine).forFormat(this.format);
        return new ParserImpl(new Lexer(dot, name), validator, this.messageConsumer).parse();
    }
}

