/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.GraphvizEngine;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphvizEngine
implements GraphvizEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGraphvizEngine.class);
    protected static final Pattern IMG_SRC = Pattern.compile("<img .*?src\\s*=\\s*['\"]([^'\"]*)");
    protected static final Pattern IMAGE_ATTR = Pattern.compile("\"?image\"?\\s*=\\s*\"(.*?)\"");
    private final boolean sync;
    protected int timeout = 10000;

    protected AbstractGraphvizEngine(boolean sync) {
        this.sync = sync;
    }

    @Override
    public void init(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        if (this.sync) {
            this.initTask(onOk, onError);
        } else {
            new Thread(() -> this.initTask(onOk, onError)).start();
        }
    }

    private void initTask(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        try {
            this.doInit();
            onOk.accept(this);
        }
        catch (Exception e) {
            LOG.info("Could not initialize {}", (Object)this, (Object)e);
            this.close();
            onError.accept(this);
        }
    }

    protected <T extends AbstractGraphvizEngine> T timeout(int amount, TimeUnit unit) {
        this.timeout = (int)TimeUnit.MILLISECONDS.convert(amount, unit);
        return (T)this;
    }

    @Override
    public void close() {
    }

    protected abstract void doInit() throws IOException;

    protected void throwingInit() {
        try {
            this.doInit();
        }
        catch (Exception e) {
            LOG.info("Could not initialize {}", (Object)this, (Object)e);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

