/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.parse;

import guru.nidi.graphviz.attribute.Attributed;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.PortNode;
import guru.nidi.graphviz.parse.Lexer;
import guru.nidi.graphviz.parse.ParserException;
import guru.nidi.graphviz.parse.Token;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Parser {
    private final Lexer lexer;
    private Token token;

    public static MutableGraph read(File file) throws IOException {
        return Parser.read(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), file.getName());
    }

    public static MutableGraph read(InputStream is) throws IOException {
        return Parser.read(new InputStreamReader(is, StandardCharsets.UTF_8), "<input stream>");
    }

    public static MutableGraph read(String dot) throws IOException {
        return Parser.read(new StringReader(dot), "<string>");
    }

    public static MutableGraph read(Reader dot, String name) throws IOException {
        return new Parser(new Lexer(dot, name)).parse();
    }

    private Parser(Lexer lexer) throws IOException {
        this.lexer = lexer;
        this.token = this.nextToken();
    }

    private MutableGraph parse() {
        return CreationContext.use(ctx -> {
            MutableGraph graph = Factory.mutGraph();
            if (this.token.type == 9) {
                graph.setStrict(true);
                this.nextToken();
            }
            if (this.token.type == 11) {
                graph.setDirected(true);
            } else if (this.token.type != 10) {
                this.fail("'graph' or 'digraph' expected");
            }
            this.nextToken();
            if (this.token.type == 16) {
                graph.setName(this.label(this.token).toString());
                this.nextToken();
            }
            this.statementList(graph);
            this.assertToken(0);
            return graph;
        });
    }

    private Label label(Token token) {
        return token.subtype == 4 ? Label.html(token.value) : Label.of(token.value);
    }

    private void statementList(MutableGraph graph) throws IOException {
        this.assertToken(3);
        while (this.statement(graph)) {
            if (this.token.type != 1) continue;
            this.nextToken();
        }
        this.assertToken(4);
    }

    private boolean statement(MutableGraph graph) throws IOException {
        Token base = this.token;
        switch (base.type) {
            case 16: {
                this.nextToken();
                if (this.token.type == 5) {
                    this.applyMutableAttributes(graph.graphAttrs(), Arrays.asList(base, this.nextToken(16)));
                    this.nextToken();
                } else {
                    PortNode nodeId = this.nodeId(base);
                    if (this.token.type == 18 || this.token.type == 19) {
                        this.edgeStatement(graph, nodeId);
                    } else {
                        this.nodeStatement(graph, nodeId);
                    }
                }
                return true;
            }
            case 3: 
            case 14: {
                MutableGraph sub = this.subgraph(graph.isDirected());
                if (this.token.type == 18 || this.token.type == 19) {
                    this.edgeStatement(graph, sub);
                } else {
                    graph.add((LinkSource)sub);
                }
                return true;
            }
            case 10: 
            case 12: 
            case 13: {
                this.attributeStatement(graph);
                return true;
            }
        }
        return false;
    }

    private MutableGraph subgraph(boolean directed) {
        return CreationContext.use(ctx -> {
            MutableGraph sub = Factory.mutGraph().setDirected(directed);
            if (this.token.type == 14) {
                this.nextToken();
                if (this.token.type == 16) {
                    sub.setName(this.label(this.token).toString());
                    this.nextToken();
                }
            }
            this.statementList(sub);
            return sub;
        });
    }

    private void edgeStatement(MutableGraph graph, LinkSource linkSource) throws IOException {
        ArrayList<LinkSource> points = new ArrayList<LinkSource>();
        points.add(linkSource);
        do {
            if (graph.isDirected() && this.token.type == 18) {
                this.fail("-- used in digraph. Use -> instead.");
            }
            if (!graph.isDirected() && this.token.type == 19) {
                this.fail("-> used in graph. Use -- instead.");
            }
            this.nextToken();
            if (this.token.type == 16) {
                Token id = this.token;
                this.nextToken();
                points.add(this.nodeId(id));
                continue;
            }
            if (this.token.type != 14 && this.token.type != 3) continue;
            points.add(this.subgraph(graph.isDirected()));
        } while (this.token.type == 18 || this.token.type == 19);
        List<Token> attrs = this.token.type == 6 ? this.attributeList() : Collections.emptyList();
        for (int i = 0; i < points.size() - 1; ++i) {
            LinkSource from = (LinkSource)points.get(i);
            LinkTarget to = (LinkTarget)points.get(i + 1);
            from.links().add(this.applyAttributes(Link.to(to), attrs));
            graph.add(from);
        }
    }

    private Compass compass(String name) {
        return Compass.of(name).orElseThrow(() -> new ParserException(this.lexer.pos, "Invalid compass value '" + name + "'"));
    }

    private void nodeStatement(MutableGraph graph, PortNode nodeId) throws IOException {
        MutableNode node = Factory.mutNode(nodeId.name());
        if (this.token.type == 6) {
            this.applyMutableAttributes(node, this.attributeList());
        }
        graph.add((LinkSource)node);
    }

    private PortNode nodeId(Token base) throws IOException {
        String record = null;
        Compass compass = null;
        if (this.token.type == 8) {
            String second = this.nextToken((int)16).value;
            this.nextToken();
            if (this.token.type == 8) {
                record = second;
                compass = this.compass(this.nextToken((int)16).value);
                this.nextToken();
            } else if (Compass.of(second).isPresent()) {
                compass = this.compass(second);
            } else {
                record = second;
            }
        }
        return Factory.mutNode(this.label(base)).port(record, compass);
    }

    private void attributeStatement(MutableGraph graph) throws IOException {
        MutableAttributed<?, ?> target = this.attributes(graph, this.token);
        this.nextToken();
        this.applyMutableAttributes(target, this.attributeList());
    }

    private void applyMutableAttributes(MutableAttributed<?, ?> attributed, List<Token> tokens) {
        for (int i = 0; i < tokens.size(); i += 2) {
            String key = tokens.get((int)i).value;
            Token value = tokens.get(i + 1);
            if ("label".equals(key) || "xlabel".equals(key) || "headlabel".equals(key) || "taillabel".equals(key)) {
                attributed.add(key, (Object)this.label(value));
                continue;
            }
            attributed.add(key, value.value);
        }
    }

    private <T extends Attributed<T, ?>> T applyAttributes(T attributed, List<Token> tokens) {
        Object res = attributed;
        for (int i = 0; i < tokens.size(); i += 2) {
            res = (Attributed)res.with(tokens.get((int)i).value, tokens.get((int)(i + 1)).value);
        }
        return res;
    }

    private MutableAttributed<?, ?> attributes(MutableGraph graph, Token token) {
        switch (token.type) {
            case 10: {
                return graph.graphAttrs();
            }
            case 12: {
                return CreationContext.get().nodeAttrs();
            }
            case 13: {
                return CreationContext.get().linkAttrs();
            }
        }
        throw new IllegalArgumentException("Unexpected token " + token);
    }

    private List<Token> attributeList() throws IOException {
        ArrayList<Token> res = new ArrayList<Token>();
        do {
            this.assertToken(6);
            if (this.token.type == 16) {
                res.addAll(this.attrListElement());
            }
            this.assertToken(7);
        } while (this.token.type == 6);
        return res;
    }

    private List<Token> attrListElement() throws IOException {
        ArrayList<Token> res = new ArrayList<Token>();
        do {
            res.add(this.token);
            this.nextToken(5);
            res.add(this.nextToken(16));
            this.nextToken();
            if (this.token.type != 1 && this.token.type != 2) continue;
            this.nextToken();
        } while (this.token.type == 16);
        return res;
    }

    private Token nextToken() throws IOException {
        this.token = this.lexer.token();
        return this.token;
    }

    private Token nextToken(int type) throws IOException {
        this.nextToken();
        this.checkToken(type);
        return this.token;
    }

    private Token assertToken(int type) throws IOException {
        this.checkToken(type);
        return this.nextToken();
    }

    private void checkToken(int type) {
        if (this.token.type != type) {
            this.fail("'" + Token.desc(type) + "' expected");
        }
    }

    private void fail(String msg) {
        throw new ParserException(this.lexer.pos, msg);
    }
}

