/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import jdepend.framework.AbstractParser;
import jdepend.framework.ClassFileParser;
import jdepend.framework.FileManager;
import jdepend.framework.JavaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassBuilder {
    private AbstractParser parser;
    private FileManager fileManager;

    public JavaClassBuilder() {
        this(new ClassFileParser(), new FileManager());
    }

    public JavaClassBuilder(FileManager fm) {
        this(new ClassFileParser(), fm);
    }

    public JavaClassBuilder(AbstractParser parser, FileManager fm) {
        this.parser = parser;
        this.fileManager = fm;
    }

    public int countClasses() {
        AbstractParser counter = new AbstractParser(){

            public JavaClass parse(InputStream is) {
                return new JavaClass("");
            }
        };
        JavaClassBuilder builder = new JavaClassBuilder(counter, this.fileManager);
        Collection<JavaClass> classes = builder.build();
        return classes.size();
    }

    public Collection<JavaClass> build() {
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        for (File nextFile : this.fileManager.extractFiles()) {
            try {
                classes.addAll(this.buildClasses(nextFile));
            }
            catch (IOException ioe) {
                System.err.println("\n" + ioe.getMessage());
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JavaClass> buildClasses(File file) throws IOException {
        if (this.fileManager.acceptClassFile(file)) {
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                JavaClass parsedClass = this.parser.parse(is);
                ArrayList<JavaClass> javaClasses = new ArrayList<JavaClass>();
                javaClasses.add(parsedClass);
                ArrayList<JavaClass> arrayList = javaClasses;
                return arrayList;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        if (this.fileManager.acceptJarFile(file)) {
            JarFile jarFile = new JarFile(file);
            Collection<JavaClass> result = this.buildClasses(jarFile);
            jarFile.close();
            return result;
        }
        throw new IOException("File is not a valid .class, .jar, .war, or .zip file: " + file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JavaClass> buildClasses(JarFile file) throws IOException {
        ArrayList<JavaClass> javaClasses = new ArrayList<JavaClass>();
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry e = entries.nextElement();
            if (!this.fileManager.acceptClassFileName(e.getName())) continue;
            InputStream is = null;
            try {
                is = new BufferedInputStream(file.getInputStream(e));
                JavaClass jc = this.parser.parse(is);
                javaClasses.add(jc);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return javaClasses;
    }
}

