/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import jdepend.framework.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFilter {
    private final Collection<Filter> filters;

    private PackageFilter(Collection<Filter> filters) {
        this.filters = filters;
    }

    private PackageFilter() {
        this(new ArrayList<Filter>());
    }

    public static PackageFilter all() {
        return new PackageFilter();
    }

    public PackageFilter excludingProperties() {
        return this.excluding(new PropertyConfigurator().getFilteredPackages());
    }

    public PackageFilter includingProperties() {
        return this.including(new PropertyConfigurator().getFilteredPackages());
    }

    public PackageFilter excludingFile(File f) {
        return this.excluding(new PropertyConfigurator(f).getFilteredPackages());
    }

    public PackageFilter including(File f) {
        return this.including(new PropertyConfigurator(f).getFilteredPackages());
    }

    public PackageFilter excluding(String ... packageNames) {
        return this.add(Arrays.asList(packageNames), false);
    }

    public PackageFilter excluding(Collection<String> packageNames) {
        return this.add(packageNames, false);
    }

    public PackageFilter excludingRest() {
        return this.excluding("");
    }

    public PackageFilter including(String ... packageNames) {
        return this.add(Arrays.asList(packageNames), true);
    }

    public PackageFilter including(Collection<String> packageNames) {
        return this.add(packageNames, true);
    }

    public boolean accept(String packageName) {
        for (Filter filter : this.filters) {
            if (!packageName.startsWith(filter.name)) continue;
            return filter.include;
        }
        return true;
    }

    private PackageFilter add(Collection<String> packageNames, boolean include) {
        for (String packageName : packageNames) {
            this.add(packageName, include);
        }
        return this;
    }

    private PackageFilter add(String packageName, boolean include) {
        if (packageName.endsWith("*")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        this.filters.add(new Filter(packageName, include));
        return this;
    }

    public Collection<Filter> getFilters() {
        return this.filters;
    }

    public static class Filter {
        public final String name;
        public final boolean include;

        public Filter(String name, boolean include) {
            this.name = name;
            this.include = include;
        }
    }
}

