/*
 * Decompiled with CFR 0.152.
 */
package jdepend.swingui;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageNode {
    private PackageNode parent;
    private JavaPackage jPackage;
    private List<PackageNode> children;
    private static NumberFormat formatter = NumberFormat.getInstance();

    public PackageNode(PackageNode parent, JavaPackage jPackage) {
        this.parent = parent;
        this.jPackage = jPackage;
        this.children = null;
    }

    public JavaPackage getPackage() {
        return this.jPackage;
    }

    public PackageNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.getCoupledPackages().size() <= 0;
    }

    protected abstract PackageNode makeNode(PackageNode var1, JavaPackage var2);

    protected abstract Collection<JavaPackage> getCoupledPackages();

    public boolean isChild(JavaPackage jPackage) {
        return true;
    }

    public List<PackageNode> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<PackageNode>();
            ArrayList<JavaPackage> packages = new ArrayList<JavaPackage>(this.getCoupledPackages());
            Collections.sort(packages, new PackageComparator(PackageComparator.byName()));
            for (JavaPackage jPackage : packages) {
                if (!this.isChild(jPackage)) continue;
                PackageNode childNode = this.makeNode(this, jPackage);
                this.children.add(childNode);
            }
        }
        return this.children;
    }

    public String toMetricsString() {
        StringBuilder label = new StringBuilder();
        label.append(this.getPackage().getName());
        label.append("  (");
        label.append("CC: " + this.getPackage().getConcreteClassCount() + "  ");
        label.append("AC: " + this.getPackage().getAbstractClassCount() + "  ");
        label.append("Ca: " + this.getPackage().afferentCoupling() + "  ");
        label.append("Ce: " + this.getPackage().efferentCoupling() + "  ");
        label.append("A: " + PackageNode.format(this.getPackage().abstractness()) + "  ");
        label.append("I: " + PackageNode.format(this.getPackage().instability()) + "  ");
        label.append("D: " + PackageNode.format(this.getPackage().distance()) + "  ");
        label.append("V: " + this.getPackage().getVolatility());
        if (this.getPackage().containsCycle()) {
            label.append(" Cyclic");
        }
        label.append(")");
        return label.toString();
    }

    public String toString() {
        if (this.getParent().getParent() == null) {
            return this.toMetricsString();
        }
        return this.getPackage().getName();
    }

    private static String format(float f) {
        return formatter.format(f);
    }

    static {
        formatter.setMaximumFractionDigits(2);
    }
}

