/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.raml.doc;

import guru.nidi.loader.Loader;
import guru.nidi.loader.basic.CachingLoaderInterceptor;
import guru.nidi.loader.basic.FileLoader;
import guru.nidi.loader.basic.InterceptingLoader;
import guru.nidi.loader.basic.LoaderInterceptor;
import guru.nidi.loader.basic.UriLoader;
import guru.nidi.loader.use.raml.RamlLoad;
import guru.nidi.raml.doc.IoUtil;
import guru.nidi.raml.doc.ResourceCache;
import guru.nidi.raml.doc.SchemaLoader;
import guru.nidi.raml.doc.st.Feature;
import guru.nidi.raml.doc.st.Generator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.raml.model.Raml;

public class GeneratorConfig {
    private final List<String> ramlLocations;
    private final File target;
    private final EnumSet<Feature> features;
    private final String baseUri;
    private final String baseUriParameters;
    private final Loader customization;
    private final boolean forceDelete;
    private final ResourceCache resourceCache;

    public GeneratorConfig(List<String> ramlLocations, File target, EnumSet<Feature> features, String baseUri, String baseUriParameters, Loader customization, boolean forceDelete) {
        this.ramlLocations = ramlLocations;
        this.target = target;
        this.features = features;
        this.baseUri = baseUri;
        this.baseUriParameters = baseUriParameters;
        this.customization = customization;
        this.forceDelete = forceDelete;
        this.resourceCache = new ResourceCache(new File(target, "@resource"));
    }

    public File getTarget() {
        return this.target;
    }

    public boolean hasFeature(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public ResourceCache getResourceCache() {
        return this.resourceCache;
    }

    public boolean isForceDelete() {
        return this.forceDelete;
    }

    public InputStream loadCustomization(String name) {
        if (this.customization == null) {
            throw new Loader.ResourceNotFoundException(name);
        }
        return this.customization.fetchResource(name, -1L);
    }

    public static String getBaseOfRaml(String ramlLocation) {
        int pos = ramlLocation.lastIndexOf(47);
        return pos < 0 ? "./" : ramlLocation.substring(0, pos);
    }

    public String getBaseUri(Raml raml) {
        if (this.baseUri != null) {
            return this.baseUri;
        }
        String baseUri = raml.getBaseUri().replace("{version}", raml.getVersion());
        if (this.baseUriParameters != null) {
            for (String param : this.baseUriParameters.split(",")) {
                String[] keyValue = param.split("=");
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException("baseUriParameters must be of the form 'key1=value1,key2=value2,...' but is '" + this.baseUriParameters + "'");
                }
                baseUri = baseUri.replace("{" + keyValue[0] + "}", keyValue[1]);
            }
        }
        if (baseUri.contains("{")) {
            throw new IllegalArgumentException("Unresolved baseUri: '" + baseUri + "'. Use 'baseUri' or 'baseUriParameters' parameters to specify it.");
        }
        return baseUri;
    }

    private LoadResults loadRamls() throws IOException {
        LoadResults res = new LoadResults();
        for (String loc : this.ramlLocations) {
            try {
                SavingLoaderInterceptor sli = new SavingLoaderInterceptor();
                InterceptingLoader loader = new InterceptingLoader((Loader)new UriLoader((Loader)new FileLoader(new File("."))), (LoaderInterceptor)sli);
                Raml raml = new RamlLoad((Loader)loader).load(loc);
                new SchemaLoader(raml, loc, (Loader)loader).loadSchemas();
                sli.raml = raml;
                res.ramls.add(raml);
                res.slis.add(sli);
            }
            catch (Exception e) {
                throw new IOException("Problem loading RAML from '" + loc + "'", e);
            }
        }
        return res;
    }

    public String generate() throws IOException {
        LoadResults loadResults = this.loadRamls();
        this.fillResourceCache(loadResults);
        Generator generator = new Generator(this);
        generator.generate(loadResults.ramls);
        this.writeResources(loadResults, generator);
        return generator.getTarget(loadResults.ramls.get(0)).getName();
    }

    private void fillResourceCache(LoadResults loadResults) throws UnsupportedEncodingException {
        for (SavingLoaderInterceptor sli : loadResults.slis) {
            for (Map.Entry entry : sli.data.entrySet()) {
                String key = sli.relativizePath((String)entry.getKey());
                this.resourceCache.cache(sli.raml, key, new String((byte[])entry.getValue(), "utf-8"));
            }
        }
    }

    private void writeResources(LoadResults loadResults, Generator generator) throws IOException {
        for (SavingLoaderInterceptor sli : loadResults.slis) {
            sli.writeDataToZip(generator);
        }
        this.resourceCache.flush();
    }

    public static String safeName(Raml raml) {
        return IoUtil.safeName(raml.getTitle());
    }

    private static class SavingLoaderInterceptor
    extends CachingLoaderInterceptor {
        private Raml raml;
        private String ramlPath;
        private final Map<String, byte[]> data = new HashMap<String, byte[]>();

        private SavingLoaderInterceptor() {
        }

        protected void processLoaded(String name, byte[] data) {
            int pos = name.indexOf("://");
            String path = pos < 0 ? name : name.substring(pos + 3);
            this.data.put(path, data);
            if (this.ramlPath == null) {
                this.ramlPath = path;
            }
        }

        public String relativizePath(String path) {
            int pos = this.ramlPath.lastIndexOf(47);
            return path.startsWith(this.ramlPath.substring(0, pos)) ? path.substring(pos + 1) : path;
        }

        public void writeDataToFiles(File dir) throws IOException {
            dir.mkdirs();
            for (Map.Entry<String, byte[]> d : this.data.entrySet()) {
                String path = IoUtil.normalizePath(d.getKey());
                ByteArrayInputStream in = new ByteArrayInputStream(d.getValue());
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(new File(dir, path));
                    Throwable throwable2 = null;
                    try {
                        int read;
                        byte[] buf = new byte[10000];
                        while ((read = in.read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, read);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable6) {
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
        }

        public void writeDataToZip(Generator generator) throws IOException {
            this.writeDataToZip(new File(generator.getTarget(this.raml), GeneratorConfig.safeName(this.raml) + ".zip"));
        }

        public void writeDataToZip(File file) throws IOException {
            file.getParentFile().mkdirs();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
            Throwable throwable = null;
            try {
                for (Map.Entry<String, byte[]> d : this.data.entrySet()) {
                    String path = IoUtil.normalizePath(d.getKey());
                    out.putNextEntry(new ZipEntry(path));
                    ByteArrayInputStream in = new ByteArrayInputStream(d.getValue());
                    Throwable throwable2 = null;
                    try {
                        int read;
                        byte[] buf = new byte[10000];
                        while ((read = in.read(buf)) > 0) {
                            out.write(buf, 0, read);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in != null) {
                            if (throwable2 != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (Throwable throwable4) {
                                }
                            } else {
                                ((InputStream)in).close();
                            }
                        }
                    }
                    out.closeEntry();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
    }

    private static class LoadResults {
        final List<Raml> ramls = new ArrayList<Raml>();
        final List<SavingLoaderInterceptor> slis = new ArrayList<SavingLoaderInterceptor>();

        private LoadResults() {
        }
    }
}

