/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.raml.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlOptimizer {
    private static final int MAX_WIDTH = 20;

    public void optimizeColumnWidths(File file) throws IOException {
        Document html = Jsoup.parse((File)file, (String)"utf-8");
        Elements tables = html.select("table");
        for (Element table : tables) {
            List<Integer[]> widthsPerRow = this.calcWidths(table);
            Integer[] maxWidths = this.calcMaxWidths(widthsPerRow);
            this.applyWidthStyle(table, maxWidths);
        }
        this.writeToFile(html, file);
    }

    private void writeToFile(Document html, File file) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath()), "utf-8");
        Throwable throwable = null;
        try {
            out.write(html.toString());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (out != null) {
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    private void applyWidthStyle(Element table, Integer[] maxWidths) {
        Element tr = table.getElementsByTag("tr").first();
        int col = 0;
        for (Element th : tr.getElementsByTag("th")) {
            if (maxWidths[col] != null && maxWidths[col] <= 20) {
                th.attr("style", "width:" + maxWidths[col] + "em;");
            }
            ++col;
        }
    }

    private Integer[] calcMaxWidths(List<Integer[]> widthsPerRow) {
        Integer[] maxWidths = new Integer[20];
        for (Integer[] widths : widthsPerRow) {
            for (int i = 0; i < widths.length; ++i) {
                if (widths[i] == null || maxWidths[i] != null && widths[i] <= maxWidths[i]) continue;
                maxWidths[i] = widths[i];
            }
        }
        return maxWidths;
    }

    private List<Integer[]> calcWidths(Element table) {
        ArrayList<Integer[]> widthsPerRow = new ArrayList<Integer[]>();
        for (Element tr : table.getElementsByTag("tr")) {
            int col = 0;
            Integer[] widths = new Integer[20];
            for (Element td : tr.getElementsByTag("td")) {
                widths[col] = this.calcWidth(td);
                int colspan = td.attr("colspan").length() == 0 ? 1 : Integer.parseInt(td.attr("colspan").trim());
                col += colspan;
            }
            widthsPerRow.add(widths);
        }
        return widthsPerRow;
    }

    private Integer calcWidth(Element td) {
        if (td.children().isEmpty()) {
            return td.text().length();
        }
        int max = 0;
        for (Element ch : td.children()) {
            if (ch.nodeName().equals("p")) {
                max = Math.max(max, ch.text().length());
                continue;
            }
            max = 1000;
        }
        return max;
    }
}

