/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.raml.doc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Pattern;

public class IoUtil {
    private static final String FILE_SYSTEM_UNSAFE = "\\/:*?\"<>|!";
    private static final String URL_UNSAFE = ":/?#[]@!$&'()*+,;=\"\\{}% ";
    private static final Pattern HAS_PROTOCOL = Pattern.compile("\\w+://.+");

    private IoUtil() {
    }

    public static String normalizePath(String path) {
        int pos;
        String res = path;
        while ((pos = res.indexOf("../")) >= 0) {
            int last = res.lastIndexOf("/", pos - 2);
            if (last >= 0) {
                res = res.substring(0, last + 1) + res.substring(pos + 3);
                continue;
            }
            if (pos > 1) {
                res = res.substring(pos + 3);
                continue;
            }
            if (!IoUtil.hasProtocol(path)) break;
            throw new IllegalStateException("Invalid path '" + path + "'");
        }
        return res;
    }

    private static boolean hasProtocol(String path) {
        return HAS_PROTOCOL.matcher(path).matches();
    }

    public static String safeName(String name) {
        return IoUtil.safe(name, false);
    }

    public static String safePath(String name) {
        return IoUtil.safe(name, true);
    }

    public static String urlEncodedSafePath(String name) {
        return IoUtil.urlEncoded(IoUtil.safePath(name)).replace("%2F", "/");
    }

    public static String urlEncodedSafeName(String name) {
        return IoUtil.urlEncoded(IoUtil.safeName(name));
    }

    private static String safe(String name, boolean allowSlash) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean ok = allowSlash && c == '/' || FILE_SYSTEM_UNSAFE.indexOf(c) < 0 && URL_UNSAFE.indexOf(c) < 0;
            s.append(ok ? c : (char)'-');
        }
        return s.toString();
    }

    public static String urlEncoded(String name) {
        try {
            return URLEncoder.encode(name, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Cannot happen");
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[1000];
        while ((read = in.read(buf)) > 0) {
            out.write(buf, 0, read);
        }
    }
}

