/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.raml.doc;

import guru.nidi.raml.doc.GeneratorConfig;
import guru.nidi.raml.doc.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.raml.model.Raml;

public class ResourceCache {
    private final Map<String, String> schemas = new HashMap<String, String>();
    private final File basedir;
    private int currentKey = 0;

    public ResourceCache(File basedir) {
        this.basedir = basedir;
    }

    public String cache(Raml raml, String schema) {
        String key = this.findSchema(raml, schema);
        if (key == null) {
            key = this.cache(raml, ++this.currentKey + ".inline", schema);
        }
        return key;
    }

    public String cache(Raml raml, String key, String schema) {
        String fullKey = this.key(raml, key);
        this.schemas.put(fullKey, schema);
        return fullKey;
    }

    private String findSchema(Raml raml, String schema) {
        for (Map.Entry<String, String> entry : this.schemas.entrySet()) {
            if (!entry.getKey().startsWith(this.key(raml, "")) || !entry.getValue().equals(schema)) continue;
            return entry.getKey();
        }
        return null;
    }

    private String key(Raml raml, String suffix) {
        return GeneratorConfig.safeName(raml) + "/" + suffix;
    }

    public String schema(String key) {
        int pos;
        String schema = this.schemas.get(key);
        if (schema == null && (pos = key.lastIndexOf(47)) > 0) {
            schema = this.schemas.get(key.substring(pos + 1));
        }
        return schema;
    }

    public void flush() throws IOException {
        for (Map.Entry<String, String> entry : this.schemas.entrySet()) {
            this.saveSchema(entry.getKey(), entry.getValue());
        }
    }

    protected void saveSchema(String key, String schema) throws IOException {
        File file = new File(this.basedir, key);
        file.getParentFile().mkdirs();
        ByteArrayInputStream in = new ByteArrayInputStream(schema.getBytes("utf-8"));
        Throwable throwable = null;
        try {
            FileOutputStream out = new FileOutputStream(file);
            Throwable throwable2 = null;
            try {
                IoUtil.copy(in, out);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (out != null) {
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable4) {
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (in != null) {
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable6) {
                    }
                } else {
                    ((InputStream)in).close();
                }
            }
        }
    }
}

