/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.raml.doc;

import com.fasterxml.jackson.databind.ObjectMapper;
import guru.nidi.loader.Loader;
import guru.nidi.raml.doc.IoUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.Response;

public class SchemaLoader {
    private final Raml raml;
    private final String loc;
    private final Loader loader;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Set<String> loaded = new HashSet<String>();

    public SchemaLoader(Raml raml, String loc, Loader loader) {
        this.raml = raml;
        this.loc = loc;
        this.loader = loader;
    }

    public void loadSchemas() {
        for (Resource resource : this.raml.getResources().values()) {
            this.loadSchemas(resource);
        }
    }

    private void loadSchemas(Resource resource) {
        for (Resource res : resource.getResources().values()) {
            this.loadSchemas(res);
        }
        for (Action action : resource.getActions().values()) {
            this.loadSchemas(action);
        }
    }

    private void loadSchemas(Action action) {
        if (action.getBody() != null) {
            for (MimeType mime : action.getBody().values()) {
                this.loadSchema(mime);
            }
        }
        for (Response response : action.getResponses().values()) {
            this.loadSchemas(response);
        }
    }

    private void loadSchemas(Response response) {
        if (response.getBody() != null) {
            for (MimeType mime : response.getBody().values()) {
                this.loadSchema(mime);
            }
        }
    }

    private void loadSchema(MimeType mime) {
        String simpleType;
        String schema = mime.getSchema();
        if (schema == null) {
            return;
        }
        String refSchema = (String)this.raml.getConsolidatedSchemas().get(schema);
        String schemaToUse = refSchema == null ? schema : refSchema;
        String type = mime.getType();
        int pos = type.indexOf(59);
        String string = simpleType = pos < 0 ? type : type.substring(0, pos);
        if (simpleType.equals("application/json") || simpleType.endsWith("+json")) {
            try {
                this.loadJsonSchema(this.loc, schemaToUse);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void loadJsonSchema(String loc, String schema) throws IOException {
        Map map = (Map)this.mapper.readValue(schema, Map.class);
        this.loadJsonSchema(map.get("id") == null ? loc : (String)map.get("id"), map);
    }

    private void loadJsonSchema(String loc, Map<String, Object> map) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.loadJsonSchema(loc, (Map)entry.getValue());
                continue;
            }
            if (!"$ref".equals(entry.getKey())) continue;
            this.doLoadJsonSchema(this.resolveUri(loc, (String)entry.getValue()));
        }
    }

    private String resolveUri(String base, String target) {
        int len;
        int hash = target.indexOf("#");
        int n = len = target.length() > hash + 1 && target.charAt(hash + 1) == '/' ? 2 : 1;
        if (hash == 0) {
            target = target.substring(len);
        } else if (hash > 0) {
            target = target.substring(0, hash);
        }
        base = base.substring(0, base.lastIndexOf(47) + 1);
        return IoUtil.normalizePath(base + target);
    }

    private void doLoadJsonSchema(String file) throws IOException {
        if (!this.loaded.contains(file)) {
            BufferedReader ref = new BufferedReader(new InputStreamReader(this.loader.fetchResource(file, -1L), "utf-8"));
            Throwable throwable = null;
            try {
                String line;
                StringBuilder s = new StringBuilder();
                while ((line = ref.readLine()) != null) {
                    s.append(line);
                }
                this.loadJsonSchema(file, s.toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ref != null) {
                    if (throwable != null) {
                        try {
                            ref.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        ref.close();
                    }
                }
            }
            this.loaded.add(file);
        }
    }
}

