/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.raml.doc.servlet;

import guru.nidi.loader.Loader;
import guru.nidi.loader.basic.UriLoader;
import guru.nidi.raml.doc.GeneratorConfig;
import guru.nidi.raml.doc.IoUtil;
import guru.nidi.raml.doc.st.Feature;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlDocServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(RamlDocServlet.class);
    private static final Map<String, String> mimeTypes = new HashMap<String, String>(){
        {
            this.put("html", "text/html");
            this.put("css", "text/css");
            this.put("js", "text/javascript");
        }
    };
    private Initer initer;

    public void init() throws ServletException {
        List<String> unknown = this.unknownParameters();
        if (!unknown.isEmpty()) {
            log.warn("Unknown init-parameters: " + unknown);
        }
        this.initer = new Initer();
    }

    public void destroy() {
        this.initer.destroy();
    }

    protected List<String> unknownParameters() {
        ArrayList<String> res = new ArrayList<String>();
        Enumeration names = this.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (InitParameter.byValue(name) != null) continue;
            res.add(name);
        }
        return res;
    }

    private String initParameter(InitParameter ip) {
        return this.getInitParameter(ip.getValue());
    }

    protected String ramlLocations() {
        return this.initParameter(InitParameter.LOCATIONS);
    }

    protected EnumSet<Feature> features() {
        return Feature.parse(this.initParameter(InitParameter.FEATURES));
    }

    protected String baseUri() {
        return this.initParameter(InitParameter.BASE_URI);
    }

    protected String baseUriParameters() {
        return this.initParameter(InitParameter.BASE_URI_PARAMS);
    }

    protected String customization() {
        return this.initParameter(InitParameter.CUSTOMIZATION);
    }

    protected Loader getCustomization() {
        final String base = this.customization() == null ? GeneratorConfig.getBaseOfRaml(this.getRamlLocations().get(0)) : this.customization();
        return new UriLoader(){

            public InputStream fetchResource(String name, long ifModifiedSince) {
                return super.fetchResource(base + "/" + name, ifModifiedSince);
            }
        };
    }

    protected GeneratorConfig createGeneratorConfig() {
        return new GeneratorConfig(this.getRamlLocations(), this.docDir(), this.features(), this.baseUri(), this.baseUriParameters(), this.getCustomization(), true);
    }

    protected List<String> getRamlLocations() {
        String locations = this.ramlLocations();
        String locs = locations == null ? "classpath://api.raml" : locations;
        return Arrays.asList(locs.split(","));
    }

    private File docDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        return new File(tempDir, "raml-doc/" + this.getServletName());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.initer.waitReady()) {
            super.doGet(req, res);
            return;
        }
        if (req.getPathInfo() == null || req.getPathInfo().length() <= 1) {
            res.sendRedirect(req.getRequestURL().append("/" + IoUtil.urlEncoded(this.initer.baseDir) + "/index.html").toString().replaceAll("([^:])/+", "$1/"));
            return;
        }
        String path = req.getPathInfo().substring(1);
        File source = new File(this.docDir(), path);
        if (!source.exists() || !source.isFile()) {
            res.sendError(404);
        } else {
            this.setContentType(this.findContentType(source.getName()), res);
            this.writeOutput(new FileInputStream(source), res);
        }
        res.flushBuffer();
    }

    private void writeOutput(InputStream is, HttpServletResponse res) throws IOException {
        InputStream in = is;
        Throwable throwable = null;
        try {
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
            Throwable throwable2 = null;
            try {
                this.copy(in, out);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (out != null) {
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable4) {
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (in != null) {
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    private String findContentType(String source) {
        int pos = source.lastIndexOf(46);
        return pos < source.length() ? mimeTypes.get(source.substring(pos + 1)) : null;
    }

    private void setContentType(String type, HttpServletResponse res) {
        if (type != null) {
            res.setHeader("Content-Type", type);
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[10000];
        while ((read = in.read(buf)) > 0) {
            out.write(buf, 0, read);
        }
    }

    private class Initer {
        private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        private String baseDir;

        public Initer() {
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        GeneratorConfig config = RamlDocServlet.this.createGeneratorConfig();
                        Initer.this.baseDir = config.generate();
                    }
                    catch (Exception e) {
                        log.error("Could not create RAML documentation", (Throwable)e);
                    }
                }
            }, 10L, TimeUnit.SECONDS);
            this.executor.shutdown();
        }

        public boolean waitReady() {
            if (!RamlDocServlet.this.features().contains((Object)Feature.ONLINE)) {
                return false;
            }
            if (!this.executor.isTerminated()) {
                try {
                    this.executor.awaitTermination(1L, TimeUnit.MINUTES);
                    this.executor.shutdownNow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        }

        public void destroy() {
            this.executor.shutdownNow();
        }
    }

    private static enum InitParameter {
        LOCATIONS("ramlLocations"),
        FEATURES("features"),
        BASE_URI("baseUri"),
        BASE_URI_PARAMS("baseUriParameters"),
        CUSTOMIZATION("customization");

        private final String value;

        private InitParameter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static InitParameter byValue(String value) {
            for (InitParameter ip : InitParameter.values()) {
                if (!ip.getValue().equals(value)) continue;
                return ip;
            }
            return null;
        }
    }
}

