/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.raml.doc.st;

import biz.gabrys.lesscss.compiler.CompilerException;
import biz.gabrys.lesscss.compiler.LessCompilerImpl;
import guru.nidi.loader.Loader;
import guru.nidi.raml.doc.GeneratorConfig;
import guru.nidi.raml.doc.HtmlOptimizer;
import guru.nidi.raml.doc.IoUtil;
import guru.nidi.raml.doc.st.ActionAdaptor;
import guru.nidi.raml.doc.st.EntrySetMapModelAdaptor;
import guru.nidi.raml.doc.st.Feature;
import guru.nidi.raml.doc.st.ParamRenderer;
import guru.nidi.raml.doc.st.RamlAdaptor;
import guru.nidi.raml.doc.st.RamlRenderer;
import guru.nidi.raml.doc.st.ResourceAdaptor;
import guru.nidi.raml.doc.st.ResponseAdaptor;
import guru.nidi.raml.doc.st.SecuritySchemeDescriptorAdaptor;
import guru.nidi.raml.doc.st.StringRenderer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.SecuritySchemeDescriptor;
import org.raml.model.parameter.AbstractParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.NoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.STWriter;

public class Generator {
    private static final Logger log = LoggerFactory.getLogger(Generator.class);
    private static final List<String> STATIC_FILES = Generator.loadStaticFileList();
    private static final List<String> CUSTOM_FILES = Arrays.asList("favicon.ico", "custom-variables.less", "custom-style.less");
    private final GeneratorConfig config;

    private static List<String> loadStaticFileList() {
        ArrayList<String> res = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(Generator.class.getResourceAsStream("/guru/nidi/raml/doc/static-files.lst")));
            Throwable throwable = null;
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    res.add(line);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Could not load static file list: " + e.getMessage()));
        }
        return res;
    }

    public Generator(GeneratorConfig config) {
        this.config = config;
    }

    public File getTarget(Raml raml) {
        return new File(this.config.getTarget(), this.filenameFor(raml));
    }

    private String filenameFor(Raml raml) {
        return GeneratorConfig.safeName(raml);
    }

    public void generate(Raml raml) throws IOException {
        this.generate(Collections.singletonList(raml));
    }

    public void generate(List<Raml> ramls) throws IOException {
        for (Raml raml : ramls) {
            this.doGenerate(raml, ramls);
        }
    }

    private void doGenerate(Raml raml, List<Raml> ramls) throws IOException {
        STGroupDir group = this.initSTGroup(raml);
        if (raml == ramls.get(0)) {
            this.config.getTarget().mkdirs();
            if (!this.config.isForceDelete()) {
                this.checkTargetEmpty(this.config.getTarget(), ramls);
            }
            this.deleteAll(this.config.getTarget());
            this.generateBase(raml, group);
        }
        File target = this.getTarget(raml);
        target.mkdirs();
        ST main = group.getInstanceOf("main/main");
        main.add("ramls", ramls);
        main.add("baseUri", this.config.hasFeature(Feature.TRYOUT) ? this.config.getBaseUri(raml) : null);
        main.add("download", (Object)this.config.hasFeature(Feature.DOWNLOAD));
        main.add("docson", (Object)this.config.hasFeature(Feature.DOCSON));
        this.set(main, "raml", raml);
        this.render(main, "/main/doc", ".", new File(target, "index.html"));
        this.renderResources(raml, main, target);
        this.renderSecurity(raml, main, target);
    }

    private void renderSecurity(Raml raml, ST main, File target) throws IOException {
        for (Map sss : raml.getSecuritySchemes()) {
            for (Map.Entry entry : sss.entrySet()) {
                this.set(main, "param", entry);
                File file = new File(target, "security-scheme/" + (String)entry.getKey() + ".html");
                this.render(main, "/securityScheme/securityScheme", "..", file);
            }
        }
    }

    private void renderResources(Raml raml, ST main, File target) throws IOException {
        for (Resource resource : new RamlAdaptor().getAllResources(raml)) {
            this.set(main, "param", resource);
            File file = new File(target, "resource" + IoUtil.safePath(resource.getUri()) + ".html");
            this.render(main, "/resource/resource", this.depth(resource.getUri()), file);
        }
    }

    private void checkTargetEmpty(File target, List<Raml> ramls) {
        for (File file : target.listFiles()) {
            if (this.isAllowedInTarget(file, ramls)) continue;
            throw new IllegalStateException("Cannot generate doc in folder '" + target + "' because it is not empty. " + "Contains " + (file.isDirectory() ? "directory" : "file") + " '" + file.getName() + "'.");
        }
    }

    private boolean isAllowedInTarget(File file, List<Raml> ramls) {
        String name = file.getName();
        return "index.html".equals(name) || name.startsWith("@resource") || this.existsTitle(name, ramls) || STATIC_FILES.contains(name) || STATIC_FILES.contains(name + "/") && file.isDirectory() || name.endsWith(".css") && STATIC_FILES.contains(name.substring(0, name.length() - 4) + ".less");
    }

    private boolean existsTitle(String name, List<Raml> ramls) {
        for (Raml raml : ramls) {
            if (!name.equals(this.filenameFor(raml))) continue;
            return true;
        }
        return false;
    }

    private void deleteAll(File target) {
        for (File file : target.listFiles()) {
            if (file.isDirectory()) {
                this.deleteAll(file);
            }
            file.delete();
        }
    }

    private STGroupDir initSTGroup(Raml raml) {
        STGroupDir group = this.loadGroupDir("guru/nidi/raml/doc/st-templates");
        group.registerModelAdaptor(Map.class, (ModelAdaptor)new EntrySetMapModelAdaptor());
        group.registerModelAdaptor(Raml.class, (ModelAdaptor)new RamlAdaptor());
        group.registerModelAdaptor(Resource.class, (ModelAdaptor)new ResourceAdaptor());
        group.registerModelAdaptor(Action.class, (ModelAdaptor)new ActionAdaptor(raml));
        group.registerModelAdaptor(SecuritySchemeDescriptor.class, (ModelAdaptor)new SecuritySchemeDescriptorAdaptor());
        group.registerModelAdaptor(Response.class, (ModelAdaptor)new ResponseAdaptor());
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer(raml, this.config.getResourceCache()));
        group.registerRenderer(AbstractParam.class, (AttributeRenderer)new ParamRenderer());
        group.registerRenderer(Raml.class, (AttributeRenderer)new RamlRenderer());
        return group;
    }

    private void generateBase(Raml raml, STGroupDir group) throws IOException {
        this.copyStaticResources(this.config.getTarget(), STATIC_FILES);
        this.copyCustomResources(this.config.getTarget(), CUSTOM_FILES);
        this.transformLessResources(this.config.getTarget());
        ST index = group.getInstanceOf("main/index");
        index.add("firstIndex", (Object)(this.filenameFor(raml) + "/index.html"));
        this.render(index, new File(this.config.getTarget(), "index.html"));
    }

    private void render(ST template, String sub, String relPath, File target) throws IOException {
        this.set(template, "template", sub);
        this.set(template, "relPath", relPath);
        this.render(template, target);
        new HtmlOptimizer().optimizeColumnWidths(target);
    }

    private void render(ST template, File file) throws IOException {
        file.getParentFile().mkdirs();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
        Throwable throwable = null;
        try {
            StringWriter sw = new StringWriter();
            template.write((STWriter)new NoIndentWriter((Writer)sw));
            out.write(sw.toString());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (out != null) {
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    private STGroupDir loadGroupDir(String path) {
        try {
            return new STGroupDir(path, '$', '$');
        }
        catch (IllegalArgumentException e) {
            STGroupDir stGroupDir = new STGroupDir(path + "/", '$', '$');
            String url = stGroupDir.root.toExternalForm();
            try {
                stGroupDir.root = new URL(url.substring(0, url.length() - 1));
                return stGroupDir;
            }
            catch (MalformedURLException me) {
                throw new IllegalArgumentException(me);
            }
        }
    }

    private void copyStaticResources(File base, List<String> names) throws IOException {
        for (String name : names) {
            if (name.endsWith("/")) continue;
            File file = new File(base, name);
            file.getParentFile().mkdirs();
            InputStream in = this.getClass().getResourceAsStream("/guru/nidi/raml/doc/static/" + name);
            Throwable throwable = null;
            try {
                FileOutputStream out = new FileOutputStream(file);
                Throwable throwable2 = null;
                try {
                    IoUtil.copy(in, out);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out == null) continue;
                    if (throwable2 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable4) {
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    private void copyCustomResources(File base, List<String> names) throws IOException {
        for (String name : names) {
            try {
                InputStream in = this.config.loadCustomization(name);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(new File(base, name));
                    Throwable throwable2 = null;
                    try {
                        IoUtil.copy(in, out);
                        log.info("Using custom " + name);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Loader.ResourceNotFoundException resourceNotFoundException) {}
        }
    }

    private void transformLessResources(File base) throws IOException {
        LessCompilerImpl compiler = new LessCompilerImpl();
        for (File file : base.listFiles()) {
            String name = file.getName();
            try {
                if (!name.endsWith(".less")) continue;
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(file.getParentFile(), name.substring(0, name.length() - 5) + ".css")), "utf-8");
                Throwable throwable = null;
                try {
                    out.write(compiler.compile(file));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)out).close();
                            }
                            catch (Throwable throwable3) {
                            }
                        } else {
                            ((Writer)out).close();
                        }
                    }
                }
            }
            catch (CompilerException e) {
                log.error("Problem compiling '" + name + "'\n" + this.stackTraceWithoutCause((Exception)((Object)e)));
            }
        }
    }

    private String stackTraceWithoutCause(Exception e) {
        String s = e.toString() + "\n";
        for (StackTraceElement traceElement : e.getStackTrace()) {
            s = s + "\tat " + traceElement + "\n";
        }
        return s;
    }

    private void set(ST template, String name, Object value) {
        template.remove(name);
        template.add(name, value);
    }

    private String depth(String s) {
        String res = "";
        int pos = -1;
        while ((pos = s.indexOf(47, pos + 1)) >= 0) {
            res = res + "../";
        }
        return res + ".";
    }
}

