/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.raml.doc.st;

import guru.nidi.raml.doc.IoUtil;
import guru.nidi.raml.doc.ResourceCache;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.raml.model.Raml;
import org.stringtemplate.v4.AttributeRenderer;

class StringRenderer
implements AttributeRenderer {
    private final Raml raml;
    private final JsBeautifyer jsBeautifyer;
    private final MarkdownProcessor markdownProcessor;
    private final ResourceCache resourceCache;

    public StringRenderer(Raml raml, ResourceCache resourceCache) {
        this.raml = raml;
        this.resourceCache = resourceCache;
        ScriptEngine engine = new ScriptEngineManager().getEngineByExtension("js");
        Invocable invocable = (Invocable)((Object)engine);
        try {
            engine.eval("var window=this;");
            engine.eval(new InputStreamReader(this.getClass().getResourceAsStream("/guru/nidi/raml/doc/static/beautify.js"), "utf-8"));
            engine.eval("jsBeautify=js_beautify;");
            this.jsBeautifyer = invocable.getInterface(JsBeautifyer.class);
            engine.eval("Inline=null;");
            engine.eval(new InputStreamReader(this.getClass().getResourceAsStream("/guru/nidi/raml/doc/marked.js"), "utf-8"));
            this.markdownProcessor = invocable.getInterface(MarkdownProcessor.class);
        }
        catch (UnsupportedEncodingException | ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString(Object o, String formatString, Locale locale) {
        String s = (String)o;
        if (formatString == null) {
            return s;
        }
        for (String fmt : formatString.split(",")) {
            s = this.format(s, fmt);
        }
        return s;
    }

    private String format(String s, String formatString) {
        String string = formatString;
        int n = -1;
        switch (string.hashCode()) {
            case 103164673: {
                if (!string.equals("lower")) break;
                n = 0;
                break;
            }
            case 246938863: {
                if (!string.equals("markdown")) break;
                n = 1;
                break;
            }
            case -1857640538: {
                if (!string.equals("summary")) break;
                n = 2;
                break;
            }
            case -907987551: {
                if (!string.equals("schema")) break;
                n = 3;
                break;
            }
            case 3401: {
                if (!string.equals("js")) break;
                n = 4;
                break;
            }
            case 111555150: {
                if (!string.equals("urled")) break;
                n = 5;
                break;
            }
            case 1721942756: {
                if (!string.equals("nameUrl")) break;
                n = 6;
                break;
            }
            case -791463158: {
                if (!string.equals("pathUrl")) break;
                n = 7;
            }
        }
        switch (n) {
            case 0: {
                return s.toLowerCase();
            }
            case 1: {
                return this.markdown(s);
            }
            case 2: {
                return this.summary(s);
            }
            case 3: {
                return this.schema(s);
            }
            case 4: {
                return this.js(s);
            }
            case 5: {
                return this.urled(s);
            }
            case 6: {
                return IoUtil.urlEncodedSafeName(s);
            }
            case 7: {
                return IoUtil.urlEncodedSafePath(s);
            }
        }
        throw new IllegalArgumentException("unknown format '" + formatString + "'");
    }

    private String urled(String s) {
        return this.resourceCache.cache(this.raml, s);
    }

    private String schema(String s) {
        String refSchema = (String)this.raml.getConsolidatedSchemas().get(s);
        return refSchema == null ? s : refSchema;
    }

    private String js(String s) {
        return this.jsBeautifyer.jsBeautify(s).replace("<", "&lt;");
    }

    private String summary(String s) {
        int pos = s.indexOf(46);
        return pos < 0 ? s : s.substring(0, pos + 1);
    }

    private String markdown(String s) {
        return this.markdownProcessor.marked(s);
    }

    public static interface MarkdownProcessor {
        public String marked(String var1);
    }

    public static interface JsBeautifyer {
        public String jsBeautify(String var1);
    }
}

