/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.basic;

import guru.nidi.loader.Loader;
import java.io.InputStream;

public class CompositeLoader
implements Loader {
    private final Loader[] loaders;

    public CompositeLoader(Loader ... loaders) {
        this.loaders = loaders;
    }

    @Override
    public InputStream fetchResource(String name, long ifModifiedSince) {
        for (Loader loader : this.loaders) {
            try {
                return loader.fetchResource(name, ifModifiedSince);
            }
            catch (Loader.ResourceNotFoundException e) {
            }
        }
        throw new Loader.ResourceNotFoundException(name);
    }

    @Override
    public String config() {
        String s = "composite";
        for (Loader loader : this.loaders) {
            s = s + "-" + loader.config();
        }
        return s;
    }
}

