/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.url;

import com.fasterxml.jackson.databind.ObjectMapper;
import guru.nidi.loader.Loader;
import guru.nidi.loader.LoaderFactory;
import guru.nidi.loader.url.SimpleUrlFetcher;
import guru.nidi.loader.url.UrlLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;

public class GithubLoader
extends UrlLoader {
    private final String resourceBase;

    public GithubLoader(final String token, String project, String resourceBase, CloseableHttpClient httpClient) {
        super("https://api.github.com/repos/" + project + "/contents", new SimpleUrlFetcher(){

            @Override
            protected HttpGet postProcessGet(HttpGet get) {
                if (token != null) {
                    get.addHeader("Authorization", "token " + token);
                }
                return get;
            }
        }, httpClient);
        this.resourceBase = resourceBase == null || resourceBase.length() == 0 ? "" : resourceBase + "/";
    }

    public GithubLoader(String token, String project) {
        this(token, project, null, null);
    }

    public GithubLoader(String project) {
        this(null, project, null, null);
    }

    @Override
    public InputStream fetchResource(String name, long ifModifiedSince) {
        try {
            InputStream raw = this.fetcher.fetchFromUrl(this.client, this.base, this.resourceBase + name, ifModifiedSince);
            if (raw == null) {
                return null;
            }
            Map desc = (Map)new ObjectMapper().readValue(raw, Map.class);
            return this.fetcher.fetchFromUrl(this.client, (String)desc.get("download_url"), "", ifModifiedSince);
        }
        catch (IOException e) {
            throw new Loader.ResourceNotFoundException(this.resourceBase + name, e);
        }
    }

    public static class Factory
    implements LoaderFactory {
        @Override
        public String supportedProtocol() {
            return "github";
        }

        @Override
        public Loader getLoader(String base, String username, String password) {
            String resourceBase;
            String project;
            int firstSlash = base.indexOf(47);
            int secondSlash = base.indexOf(47, firstSlash + 1);
            if (secondSlash > 0) {
                project = base.substring(0, secondSlash);
                resourceBase = base.substring(secondSlash + 1);
            } else {
                project = base;
                resourceBase = null;
            }
            return new GithubLoader(username, project, resourceBase, null);
        }
    }
}

