/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.use.xml;

import guru.nidi.loader.Loader;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class LoaderLSResourceResolver
implements LSResourceResolver {
    private static final DOMImplementationLS DOM_IMPLEMENTATION_LS;
    private final Loader loader;

    public LoaderLSResourceResolver(Loader loader) {
        this.loader = loader;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LSInput input = DOM_IMPLEMENTATION_LS.createLSInput();
        input.setPublicId(publicId);
        input.setSystemId(systemId);
        input.setBaseURI(baseURI);
        input.setByteStream(this.loader.fetchResource(systemId, -1L));
        return input;
    }

    static {
        try {
            DOM_IMPLEMENTATION_LS = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not initialize DOM implementation", e);
        }
    }
}

