/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.apidesigner;

import guru.nidi.loader.Loader;
import guru.nidi.loader.LoaderFactory;
import guru.nidi.loader.apidesigner.ApiDesignerFilesResponse;
import guru.nidi.loader.apidesigner.ApiPortalFilesResponse;
import guru.nidi.loader.repository.RepositoryLoader;
import guru.nidi.loader.url.FormLoginUrlFetcher;
import guru.nidi.loader.url.SimpleUrlFetcher;
import guru.nidi.loader.url.UrlLoader;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ApiLoader
extends RepositoryLoader {
    public ApiLoader(String user, String password) {
        this(null, user, password);
    }

    public ApiLoader(String base, String user, String password) {
        super(new UrlLoader("http://api-portal.anypoint.mulesoft.com", new FormLoginUrlFetcher("rest/raml/v1", "ajax/apihub/login-register/form?section=login", user, password, "name", "pass"){

            @Override
            protected void postProcessLoginParameters(List<NameValuePair> parameters) {
                parameters.add((NameValuePair)new BasicNameValuePair("form_id", "user_login"));
            }
        }), base, "files", ApiPortalFilesResponse.class);
    }

    public ApiLoader(String baseUrl) {
        super(new UrlLoader(baseUrl, new SimpleUrlFetcher()), null, "files", ApiDesignerFilesResponse.class);
    }

    public static class DesignerFactory
    implements LoaderFactory {
        @Override
        public String supportedProtocol() {
            return "apidesigner";
        }

        @Override
        public Loader getLoader(String base, String username, String password) {
            return new ApiLoader(base);
        }
    }

    public static class PortalFactory
    implements LoaderFactory {
        @Override
        public String supportedProtocol() {
            return "apiportal";
        }

        @Override
        public Loader getLoader(String base, String username, String password) {
            return new ApiLoader(base, username, password);
        }
    }
}

