/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.basic;

import guru.nidi.loader.Loader;
import guru.nidi.loader.LoaderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileLoader
implements Loader {
    private final File base;

    public FileLoader(File base) {
        this.base = base;
    }

    @Override
    public InputStream fetchResource(String name, long ifModifiedSince) {
        try {
            File file = new File(this.base, name);
            return file.lastModified() > ifModifiedSince ? new FileInputStream(file) : null;
        }
        catch (FileNotFoundException e) {
            throw new Loader.ResourceNotFoundException(name, e);
        }
    }

    @Override
    public String config() {
        return "file-" + this.base.getAbsolutePath();
    }

    public static class Factory
    implements LoaderFactory {
        @Override
        public String supportedProtocol() {
            return "file";
        }

        @Override
        public Loader getLoader(String base, String username, String password) {
            return new FileLoader(new File(base));
        }
    }
}

