/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.repository;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import guru.nidi.loader.Loader;
import guru.nidi.loader.repository.RepositoryEntry;
import guru.nidi.loader.repository.RepositoryResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class RepositoryLoader
implements Loader {
    private final Loader loader;
    private final String defaultResourceName;
    private final String responseName;
    private final Class<? extends RepositoryResponse> responseClass;
    private RepositoryResponse response;

    public RepositoryLoader(Loader loader, String defaultResourceName, String responseName, Class<? extends RepositoryResponse> responseClass) {
        this.loader = loader;
        this.defaultResourceName = defaultResourceName;
        this.responseName = responseName;
        this.responseClass = responseClass;
    }

    @Override
    public InputStream fetchResource(String resourceName, long ifModifiedSince) {
        String name;
        RepositoryEntry entry;
        if (this.response == null) {
            this.response = this.load();
        }
        if ((entry = this.findEntry(name = resourceName != null ? resourceName : this.defaultResourceName)) == null) {
            throw new Loader.ResourceNotFoundException(name);
        }
        return new ByteArrayInputStream(entry.getContent().getBytes(Charset.forName("utf-8")));
    }

    @Override
    public String config() {
        return "repository-" + this.defaultResourceName + "-" + this.loader.config();
    }

    protected RepositoryResponse load() {
        ObjectMapper mapper = this.createMapper();
        InputStream files = this.loader.fetchResource(this.responseName, -1L);
        try {
            return (RepositoryResponse)mapper.readValue(files, this.responseClass);
        }
        catch (IOException e) {
            throw new Loader.ResourceNotFoundException(this.responseName, e);
        }
    }

    private ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    private RepositoryEntry findEntry(String name) {
        for (RepositoryEntry repositoryEntry : this.response.getFiles()) {
            if (!name.equals(repositoryEntry.getName()) && !name.equals(repositoryEntry.getPath())) continue;
            return repositoryEntry;
        }
        return null;
    }
}

