/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.url;

import com.fasterxml.jackson.databind.ObjectMapper;
import guru.nidi.loader.Loader;
import guru.nidi.loader.LoaderFactory;
import guru.nidi.loader.url.SimpleUrlFetcher;
import guru.nidi.loader.url.UrlLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;

public class GithubLoader
extends UrlLoader {
    private final String resourceBase;

    private GithubLoader(final String token, String user, String project, String resourceBase, CloseableHttpClient httpClient) {
        super("https://api.github.com/repos/" + user + "/" + project + "/contents", new SimpleUrlFetcher(){

            @Override
            protected HttpGet postProcessGet(HttpGet get) {
                if (token != null) {
                    get.addHeader("Authorization", "token " + token);
                }
                return get;
            }
        }, httpClient);
        this.resourceBase = resourceBase == null || resourceBase.length() == 0 ? "" : resourceBase + "/";
    }

    public static GithubLoader forPublic(String user, String project) {
        return new GithubLoader(null, user, project, null, null);
    }

    public static GithubLoader forPublic(String user, String project, String resourceBase) {
        return new GithubLoader(null, user, project, resourceBase, null);
    }

    public static GithubLoader forPrivate(String token, String user, String project) {
        return new GithubLoader(token, user, project, null, null);
    }

    public static GithubLoader forPrivate(String token, String user, String project, String resourceBase) {
        return new GithubLoader(token, user, project, resourceBase, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream fetchResource(String name, long ifModifiedSince) {
        try {
            InputStream raw = this.fetcher.fetchFromUrl(this.client, this.base, this.resourceBase + name, ifModifiedSince);
            Throwable throwable = null;
            try {
                if (raw == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                Map desc = (Map)new ObjectMapper().readValue(raw, Map.class);
                InputStream inputStream = this.fetcher.fetchFromUrl(this.client, (String)desc.get("download_url"), "", ifModifiedSince);
                return inputStream;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (raw != null) {
                    if (throwable != null) {
                        try {
                            raw.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        raw.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new Loader.ResourceNotFoundException(this.resourceBase + name, e);
        }
    }

    public static class Factory
    implements LoaderFactory {
        @Override
        public String supportedProtocol() {
            return "github";
        }

        @Override
        public Loader getLoader(String base, String username, String password) {
            String resourceBase;
            String project;
            int firstSlash = base.indexOf(47);
            int secondSlash = base.indexOf(47, firstSlash + 1);
            String user = base.substring(0, firstSlash);
            if (secondSlash > 0) {
                project = base.substring(firstSlash + 1, secondSlash);
                resourceBase = base.substring(secondSlash + 1);
            } else {
                project = base.substring(firstSlash + 1);
                resourceBase = null;
            }
            return new GithubLoader(username, user, project, resourceBase, null);
        }
    }
}

