/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.url;

import guru.nidi.loader.url.UrlFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class SimpleUrlFetcher
implements UrlFetcher {
    private static final String HTTP_DATE_FORMAT = "E, dd MMM yyyy HH:mm:ss 'GMT'";

    @Override
    public InputStream fetchFromUrl(CloseableHttpClient client, String base, String name, long ifModifiedSince) throws IOException {
        String suffix = name == null || name.length() == 0 ? "" : "/" + this.encodeUrl(name);
        HttpGet get = this.postProcessGet(new HttpGet(base + suffix));
        if (ifModifiedSince > 0L) {
            get.addHeader("if-modified-since", this.httpDate(ifModifiedSince));
        }
        CloseableHttpResponse getResult = client.execute((HttpUriRequest)get);
        switch (getResult.getStatusLine().getStatusCode()) {
            case 200: {
                return new AutoCloseInputStream(getResult.getEntity().getContent());
            }
            case 304: {
                EntityUtils.consume((HttpEntity)getResult.getEntity());
                return null;
            }
        }
        throw new IOException("Http response status not ok: " + getResult.getStatusLine().toString());
    }

    protected String encodeUrl(String name) {
        return name.replace(" ", "%20");
    }

    protected HttpGet postProcessGet(HttpGet get) {
        return get;
    }

    private String httpDate(long date) {
        SimpleDateFormat format = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(date);
    }
}

