/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.url;

import guru.nidi.loader.Loader;
import guru.nidi.loader.LoaderFactory;
import guru.nidi.loader.url.BasicAuthUrlLoader;
import guru.nidi.loader.url.SimpleUrlFetcher;
import guru.nidi.loader.url.UrlFetcher;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class UrlLoader
implements Loader {
    protected final String base;
    protected final CloseableHttpClient client;
    protected final UrlFetcher fetcher;

    public UrlLoader(String base, UrlFetcher fetcher, CloseableHttpClient httpClient) {
        this.base = base;
        this.fetcher = fetcher;
        this.client = httpClient == null ? HttpClientBuilder.create().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build() : httpClient;
    }

    public UrlLoader(String base, UrlFetcher fetcher) {
        this(base, fetcher, null);
    }

    public UrlLoader(String baseUrl) {
        this(baseUrl, new SimpleUrlFetcher(), null);
    }

    @Override
    public InputStream fetchResource(String name, long ifModifiedSince) {
        try {
            return this.fetcher.fetchFromUrl(this.client, this.base, name, ifModifiedSince);
        }
        catch (IOException e) {
            throw new Loader.ResourceNotFoundException(name, e);
        }
    }

    @Override
    public String config() {
        return "url-" + this.base;
    }

    public static class HttpsFactory
    implements LoaderFactory {
        @Override
        public String supportedProtocol() {
            return "https";
        }

        @Override
        public Loader getLoader(String base, String username, String password) {
            return username == null ? new UrlLoader("https://" + base) : new BasicAuthUrlLoader("https://" + base, username, password);
        }
    }

    public static class HttpFactory
    implements LoaderFactory {
        @Override
        public String supportedProtocol() {
            return "http";
        }

        @Override
        public Loader getLoader(String base, String username, String password) {
            return username == null ? new UrlLoader("http://" + base) : new BasicAuthUrlLoader("http://" + base, username, password);
        }
    }
}

