/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.basic;

import guru.nidi.loader.Loader;
import guru.nidi.loader.LoaderFactory;
import guru.nidi.loader.ResourceNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ClassPathLoader
implements Loader {
    private static final String FILE_COLON = "file:";
    private final String base;

    public ClassPathLoader() {
        this("");
    }

    public ClassPathLoader(String base) {
        this.base = base == null || base.length() == 0 ? "" : (base.endsWith("/") ? base : base + "/");
    }

    @Override
    public InputStream fetchResource(String name, long ifModifiedSince) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.normalize(name));
        if (url == null) {
            throw new ResourceNotFoundException(name);
        }
        try {
            String path = url.getPath();
            String string = url.getProtocol();
            int n = -1;
            switch (string.hashCode()) {
                case 3143036: {
                    if (!string.equals("file")) break;
                    n = 0;
                    break;
                }
                case 104987: {
                    if (!string.equals("jar")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    File file = new File(path);
                    return file.lastModified() > ifModifiedSince ? url.openStream() : null;
                }
                case 1: {
                    if (path.startsWith(FILE_COLON)) {
                        int pos = path.indexOf(33);
                        File jar = new File(path.substring(FILE_COLON.length(), pos));
                        return jar.lastModified() > ifModifiedSince ? url.openStream() : null;
                    }
                    return url.openStream();
                }
            }
            return url.openStream();
        }
        catch (IOException e) {
            throw new ResourceNotFoundException(name, e);
        }
    }

    private String normalize(String path) {
        int pos;
        String res = this.base + (path.startsWith("/") ? path.substring(1) : path);
        res = res.replace("/./", "/");
        while ((pos = res.indexOf("../")) >= 0) {
            int before = res.lastIndexOf(47, pos - 2);
            if (before >= 0) {
                res = res.substring(0, before) + res.substring(pos + 2);
                continue;
            }
            if (pos <= 1) {
                throw new IllegalArgumentException("Invalid path '" + path + "'");
            }
            res = res.substring(pos + 3);
        }
        return res;
    }

    @Override
    public String config() {
        return "classpath-" + this.base;
    }

    public static class Factory
    implements LoaderFactory {
        @Override
        public String supportedProtocol() {
            return "classpath";
        }

        @Override
        public Loader getLoader(String base, String username, String password) {
            return new ClassPathLoader(base);
        }
    }
}

