/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.basic;

import guru.nidi.loader.Loader;
import guru.nidi.loader.ResourceNotFoundException;
import java.io.InputStream;

public class CompositeLoader
implements Loader {
    private final Loader[] loaders;

    public CompositeLoader(Loader ... loaders) {
        this.loaders = loaders;
    }

    @Override
    public InputStream fetchResource(String name, long ifModifiedSince) {
        for (Loader loader : this.loaders) {
            try {
                return loader.fetchResource(name, ifModifiedSince);
            }
            catch (ResourceNotFoundException e) {
            }
        }
        throw new ResourceNotFoundException(name);
    }

    @Override
    public String config() {
        StringBuilder s = new StringBuilder("composite");
        for (Loader loader : this.loaders) {
            s.append('-').append(loader.config());
        }
        return s.toString();
    }
}

