/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.basic;

import guru.nidi.loader.Loader;
import guru.nidi.loader.LoaderFactory;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriLoader
implements Loader {
    private static final Pattern ABSOLUTE_URI_PATTERN = Pattern.compile("(([^:]+):?([^@]*)@)?([^:]+)://(.+)");
    private static final int GROUP_USER = 2;
    private static final int GROUP_PASSWORD = 3;
    private static final int GROUP_PROTOCOL = 4;
    private static final int GROUP_PATH = 5;
    private static final Map<String, LoaderFactory> FACTORIES = new HashMap<String, LoaderFactory>();
    private final Loader relativeLoader;

    public UriLoader() {
        this(null);
    }

    public UriLoader(Loader relativeLoader) {
        this.relativeLoader = relativeLoader;
    }

    @Override
    public InputStream fetchResource(String name, long ifModifiedSince) {
        String normalized = this.normalizeResourceName(name);
        Matcher matcher = ABSOLUTE_URI_PATTERN.matcher(normalized);
        if (matcher.matches()) {
            int query;
            String path = matcher.group(5);
            String res = "";
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash >= 0 && lastSlash < path.length() - 1) {
                res = path.substring(lastSlash + 1);
                path = path.substring(0, lastSlash);
            }
            if ((query = res.indexOf(63)) >= 0) {
                path = path + res.substring(query);
                res = res.substring(0, query);
            }
            return this.absoluteLoader(matcher.group(4), path, matcher.group(2), matcher.group(3)).fetchResource(res, ifModifiedSince);
        }
        if (this.relativeLoader == null) {
            throw new IllegalArgumentException("Expected absolute uri '[username:password@]protocol://base[/file]', but got '" + name + "'");
        }
        return this.relativeLoader.fetchResource(normalized, ifModifiedSince);
    }

    @Override
    public String config() {
        return "uri-" + (this.relativeLoader == null ? "" : this.relativeLoader.config());
    }

    private String normalizeResourceName(String name) {
        if (name.startsWith("//")) {
            return "classpath:" + name;
        }
        int firstProtocol = name.indexOf("://");
        int secondProtocol = name.indexOf("://", firstProtocol + 1);
        int protocol = secondProtocol < 0 ? firstProtocol : secondProtocol;
        int endOfFirst = name.lastIndexOf("/", protocol);
        if (endOfFirst >= 0) {
            return name.substring(endOfFirst + 1);
        }
        return name;
    }

    private Loader absoluteLoader(String protocol, String base, String username, String password) {
        LoaderFactory factory = FACTORIES.get(protocol);
        if (factory == null) {
            throw new IllegalArgumentException("Unsupported protocol " + protocol);
        }
        return factory.getLoader(base, username, password);
    }

    static {
        ServiceLoader<LoaderFactory> loader = ServiceLoader.load(LoaderFactory.class);
        for (LoaderFactory factory : loader) {
            FACTORIES.put(factory.supportedProtocol(), factory);
        }
    }
}

