/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.url;

import guru.nidi.loader.ResourceNotFoundException;
import guru.nidi.loader.url.SimpleUrlFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class FormLoginUrlFetcher
extends SimpleUrlFetcher {
    private final String loadPath;
    private final String loginUrl;
    private final String login;
    private final String password;
    private final String loginField;
    private final String passwordField;

    public FormLoginUrlFetcher(String loadPath, String loginPath, String login, String password, String loginField, String passwordField) {
        this.loadPath = loadPath;
        this.login = login;
        this.password = password;
        this.loginUrl = loginPath;
        this.loginField = loginField;
        this.passwordField = passwordField;
    }

    @Override
    public InputStream fetchFromUrl(CloseableHttpClient client, String base, String name, long ifModifiedSince) {
        try {
            HttpPost login = new HttpPost(base + "/" + this.loginUrl);
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair(this.loginField, this.login));
            params.add((NameValuePair)new BasicNameValuePair(this.passwordField, this.password));
            this.postProcessLoginParameters(params);
            login.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            CloseableHttpResponse getResult = client.execute((HttpUriRequest)this.postProcessLogin(login));
            Throwable throwable = null;
            try {
                if (getResult.getStatusLine().getStatusCode() != 302) {
                    throw new ResourceNotFoundException(name, "Could not login: " + getResult.getStatusLine().toString());
                }
                EntityUtils.consume((HttpEntity)getResult.getEntity());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (getResult != null) {
                    if (throwable != null) {
                        try {
                            getResult.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        getResult.close();
                    }
                }
            }
            return super.fetchFromUrl(client, base + "/" + this.loadPath, name, ifModifiedSince);
        }
        catch (IOException e) {
            throw new ResourceNotFoundException(name, e);
        }
    }

    protected void postProcessLoginParameters(List<NameValuePair> parameters) {
    }

    protected HttpPost postProcessLogin(HttpPost login) {
        return login;
    }
}

