/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.url;

import com.fasterxml.jackson.databind.ObjectMapper;
import guru.nidi.loader.Loader;
import guru.nidi.loader.LoaderFactory;
import guru.nidi.loader.ResourceNotFoundException;
import guru.nidi.loader.url.SimpleUrlFetcher;
import guru.nidi.loader.url.UrlLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;

public class GithubLoader
extends UrlLoader {
    private final String token;
    private final String user;
    private final String project;
    private final String resourceBase;
    private final String ref;
    private final CloseableHttpClient httpClient;

    GithubLoader(final String token, String user, String project, String resourceBase, String ref, CloseableHttpClient httpClient) {
        super("https://api.github.com/repos/" + user + "/" + project + "/contents" + (ref == null ? "" : "?ref=" + ref), new SimpleUrlFetcher(){

            @Override
            protected HttpGet postProcessGet(HttpGet get) {
                if (token != null) {
                    get.addHeader("Authorization", "token " + token);
                }
                return get;
            }
        }, httpClient);
        this.token = token;
        this.user = user;
        this.project = project;
        this.resourceBase = resourceBase;
        this.ref = ref;
        this.httpClient = httpClient;
    }

    public static GithubLoader forPublic(String user, String project) {
        return new GithubLoader(null, user, project, null, null, null);
    }

    public static GithubLoader forPrivate(String token, String user, String project) {
        return new GithubLoader(token, user, project, null, null, null);
    }

    public GithubLoader resourceBase(String resourceBase) {
        return new GithubLoader(this.token, this.user, this.project, resourceBase, this.ref, this.httpClient);
    }

    public GithubLoader ref(String ref) {
        return new GithubLoader(this.token, this.user, this.project, this.resourceBase, ref, this.httpClient);
    }

    public GithubLoader commit(String commit) {
        return new GithubLoader(this.token, this.user, this.project, this.resourceBase, commit, this.httpClient);
    }

    public GithubLoader branch(String branch) {
        return new GithubLoader(this.token, this.user, this.project, this.resourceBase, branch, this.httpClient);
    }

    public GithubLoader tag(String tag) {
        return new GithubLoader(this.token, this.user, this.project, this.resourceBase, tag, this.httpClient);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream fetchResource(String name, long ifModifiedSince) {
        String res = this.resourceBase == null || this.resourceBase.length() == 0 ? "" : this.resourceBase + "/";
        try {
            InputStream raw = this.fetcher.fetchFromUrl(this.client, this.base, res + name, ifModifiedSince);
            Throwable throwable = null;
            try {
                if (raw == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                Map desc = (Map)new ObjectMapper().readValue(raw, Map.class);
                InputStream inputStream = this.fetcher.fetchFromUrl(this.client, (String)desc.get("download_url"), "", ifModifiedSince);
                return inputStream;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (raw != null) {
                    if (throwable != null) {
                        try {
                            raw.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        raw.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ResourceNotFoundException(res + name, e);
        }
    }

    public static class Factory
    implements LoaderFactory {
        @Override
        public String supportedProtocol() {
            return "github";
        }

        @Override
        public Loader getLoader(String base, String username, String password) {
            String resourceBase;
            String project;
            int queryPos = base.indexOf(63);
            String path = queryPos < 0 ? base : base.substring(0, queryPos);
            String query = queryPos < 0 ? "" : base.substring(queryPos + 1);
            Map<String, String> params = this.parseQuery(query);
            int firstSlash = path.indexOf(47);
            int secondSlash = path.indexOf(47, firstSlash + 1);
            String user = path.substring(0, firstSlash);
            if (secondSlash > 0) {
                project = path.substring(firstSlash + 1, secondSlash);
                resourceBase = path.substring(secondSlash + 1);
            } else {
                project = path.substring(firstSlash + 1);
                resourceBase = null;
            }
            return new GithubLoader(username, user, project, resourceBase, params.get("ref"), null);
        }

        private Map<String, String> parseQuery(String query) {
            HashMap<String, String> params = new HashMap<String, String>();
            for (String param : query.split("&")) {
                int pos = param.indexOf(61);
                params.put(pos < 0 ? param : param.substring(0, pos), pos < 0 ? null : param.substring(pos + 1));
            }
            return params;
        }
    }
}

