/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.use.jsonschema;

import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfigurationBuilder;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.report.ReportProvider;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonSchemaFactoryBuilder;
import guru.nidi.loader.Loader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class LoaderUriDownloader
implements URIDownloader {
    private final Loader delegate;

    public LoaderUriDownloader(Loader delegate) {
        this.delegate = delegate;
    }

    public static JsonSchemaFactory createJsonSchemaFactory(Loader loader) {
        return LoaderUriDownloader.createJsonSchemaFactory(loader, null, null, null);
    }

    public static JsonSchemaFactory createJsonSchemaFactory(Loader loader, LoadingConfiguration loadingConfiguration, ReportProvider reportProvider, ValidationConfiguration validationConfiguration) {
        JsonSchemaFactoryBuilder builder = JsonSchemaFactory.newBuilder();
        String scheme = loader.getClass().getSimpleName();
        LoadingConfigurationBuilder lcb = (loadingConfiguration == null ? LoadingConfiguration.byDefault() : loadingConfiguration).thaw().addScheme(scheme, (URIDownloader)new LoaderUriDownloader(loader)).setURITranslatorConfiguration(URITranslatorConfiguration.newBuilder().setNamespace(scheme + ":///").freeze());
        builder.setLoadingConfiguration(lcb.freeze());
        if (reportProvider != null) {
            builder.setReportProvider(reportProvider);
        }
        if (validationConfiguration != null) {
            builder.setValidationConfiguration(validationConfiguration);
        }
        return builder.freeze();
    }

    public InputStream fetch(URI source) throws IOException {
        return this.delegate.fetchResource(source.getPath(), -1L);
    }
}

