/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.use.raml;

import guru.nidi.loader.Loader;
import guru.nidi.loader.use.raml.LoaderRamlResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.ResourceLoader;

public class RamlCache {
    private static final File CACHE_DIR = new File(System.getProperty("java.io.tmpdir"), "bamls");
    private final Loader loader;

    public RamlCache(Loader loader) {
        this.loader = loader;
    }

    public RamlModelResult loadRaml(String name) {
        File file = new File(CACHE_DIR, this.escaped(this.loader.config()) + "-" + this.escaped(this.simpleName(name)) + ".braml");
        if (!file.exists()) {
            return this.parseAndSave(this.loader, name, file);
        }
        InputStream in = this.loader.fetchResource(name, file.lastModified());
        if (in != null) {
            byte[] data = this.loadedData(name, in);
            return this.parseAndSave(new PreloadedLoader(this.loader, name, data), name, file);
        }
        try {
            return this.load(file);
        }
        catch (IOException | ClassNotFoundException e) {
            return this.parseAndSave(this.loader, name, file);
        }
    }

    private String simpleName(String name) {
        int user = name.indexOf(64);
        int suffix = name.lastIndexOf(46);
        return name.substring(user + 1, suffix < 0 ? name.length() : suffix);
    }

    private RamlModelResult parseAndSave(Loader loader, String name, File file) {
        RamlModelResult raml = new RamlModelBuilder((ResourceLoader)new LoaderRamlResourceLoader(loader)).buildApi(name);
        this.save(raml, file);
        return raml;
    }

    private void save(RamlModelResult raml, File file) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
            Throwable throwable = null;
            try {
                oos.writeObject(raml);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (oos != null) {
                    if (throwable != null) {
                        try {
                            oos.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        oos.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private RamlModelResult load(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        Throwable throwable = null;
        try {
            RamlModelResult ramlModelResult = (RamlModelResult)ois.readObject();
            return ramlModelResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (ois != null) {
                if (throwable != null) {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    ois.close();
                }
            }
        }
    }

    private String escaped(String name) {
        StringBuilder s = new StringBuilder(name);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            s.setCharAt(i, '-');
        }
        return s.toString();
    }

    /*
     * Exception decompiling
     */
    private byte[] loadedData(String name, InputStream ramlInputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        CACHE_DIR.mkdirs();
    }

    private static class PreloadedLoader
    implements Loader {
        private final Loader loader;
        private final String name;
        private final byte[] data;

        public PreloadedLoader(Loader loader, String name, byte[] data) {
            this.loader = loader;
            this.name = name;
            this.data = data;
        }

        @Override
        public InputStream fetchResource(String name, long ifModifiedSince) {
            if (name.equals(this.name)) {
                return new ByteArrayInputStream(this.data);
            }
            return this.loader.fetchResource(name, ifModifiedSince);
        }

        @Override
        public String config() {
            return this.loader.config();
        }
    }
}

