/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.loader.use.xml;

import guru.nidi.loader.Loader;
import guru.nidi.loader.LoadingException;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class LoaderLSResourceResolver
implements LSResourceResolver {
    private static final DOMImplementationLS DOM_IMPLEMENTATION_LS;
    private final Loader loader;

    public LoaderLSResourceResolver(Loader loader) {
        this.loader = loader;
    }

    public static SchemaFactory createXmlSchemaFactory(Loader loader) {
        return LoaderLSResourceResolver.createSchemaFactory(loader, "http://www.w3.org/2001/XMLSchema");
    }

    public static SchemaFactory createRelaxNgSchemaFactory(Loader loader) {
        return LoaderLSResourceResolver.createSchemaFactory(loader, "http://relaxng.org/ns/structure/1.0");
    }

    public static SchemaFactory createSchemaFactory(Loader loader, String schemaLanguage) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
        schemaFactory.setResourceResolver(new LoaderLSResourceResolver(loader));
        return schemaFactory;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LSInput input = DOM_IMPLEMENTATION_LS.createLSInput();
        input.setPublicId(publicId);
        input.setSystemId(systemId);
        input.setBaseURI(baseURI);
        input.setByteStream(this.loader.fetchResource(systemId, -1L));
        return input;
    }

    static {
        try {
            DOM_IMPLEMENTATION_LS = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
        }
        catch (Exception e) {
            throw new LoadingException("Could not initialize DOM implementation", e);
        }
    }
}

