/*
 * Copyright (C) 2014 Stefan Niederhauser (nidin@gmx.ch)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package guru.nidi.ramltester.restassured3;

import guru.nidi.ramltester.core.RamlChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportStore;
import io.restassured.RestAssured;
import io.restassured.specification.RequestSpecification;

public class RestAssuredClient {
    private final RequestSpecification requestSpecification;
    private final ReportStore reportStore;

    public RestAssuredClient(RamlChecker checker) {
        this(new RamlValidationFilter(checker));
    }

    public RestAssuredClient(RamlValidationFilter filter) {
        this(RestAssured.given().filter(filter), filter.getReportStore());
    }

    public RestAssuredClient(RequestSpecification requestSpecification, ReportStore reportStore) {
        this.requestSpecification = requestSpecification;
        this.reportStore = reportStore;
    }

    public RequestSpecification given() {
        return requestSpecification.given();
    }

    public RamlReport getLastReport() {
        return reportStore.getLastReport();
    }

}
