/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester;

import guru.nidi.ramltester.SchemaValidators;
import guru.nidi.ramltester.core.CheckerConfig;
import guru.nidi.ramltester.core.RamlChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.RamlValidator;
import guru.nidi.ramltester.httpcomponents.RamlHttpClient;
import guru.nidi.ramltester.jaxrs.CheckingWebTarget;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.RamlResponse;
import guru.nidi.ramltester.restassured.RestAssuredClient;
import guru.nidi.ramltester.servlet.ServletTester;
import guru.nidi.ramltester.spring.RamlMatcher;
import guru.nidi.ramltester.spring.RamlRestTemplate;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.ws.rs.client.WebTarget;
import org.apache.http.impl.client.CloseableHttpClient;
import org.raml.model.Raml;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.web.client.RestTemplate;

public class RamlDefinition {
    private final CheckerConfig config;

    public RamlDefinition(Raml raml, SchemaValidators schemaValidators) {
        this(new CheckerConfig(raml, schemaValidators.getValidators()));
    }

    public RamlDefinition(CheckerConfig config) {
        this.config = config;
    }

    public RamlDefinition assumingBaseUri(String baseUri) {
        return new RamlDefinition(this.config.assumingBaseUri(baseUri));
    }

    public RamlDefinition assumingBaseUri(String baseUri, boolean includeServletPath) {
        return new RamlDefinition(this.config.assumingBaseUri(baseUri, includeServletPath));
    }

    public RamlDefinition ignoringXheaders() {
        return this.ignoringXheaders(true);
    }

    public RamlDefinition ignoringXheaders(boolean ignoreXheaders) {
        return new RamlDefinition(this.config.ignoringXheaders(ignoreXheaders));
    }

    public RamlDefinition includeServletPath() {
        return this.includeServletPath(true);
    }

    public RamlDefinition includeServletPath(boolean includeServletPath) {
        return new RamlDefinition(this.config.includeServletPath(includeServletPath));
    }

    public RamlDefinition failFast() {
        return this.failFast(true);
    }

    public RamlDefinition failFast(boolean failFast) {
        return new RamlDefinition(this.config.failFast(failFast));
    }

    public Raml getRaml() {
        return this.config.raml;
    }

    public RamlReport testAgainst(RamlRequest request, RamlResponse response) {
        return this.createTester().check(request, response);
    }

    public RamlReport testAgainst(MvcResult mvcResult) {
        return this.matches().testAgainst(mvcResult);
    }

    public RamlReport testAgainst(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        return new ServletTester(this.createTester()).testAgainst(request, response, chain);
    }

    public RamlMatcher matches() {
        return new RamlMatcher(this.createTester());
    }

    public RamlRestTemplate createRestTemplate(ClientHttpRequestFactory requestFactory) {
        return new RamlRestTemplate(this.createTester(), requestFactory);
    }

    public RamlRestTemplate createRestTemplate(RestTemplate restTemplate) {
        return new RamlRestTemplate(this.createTester(), restTemplate);
    }

    public RamlHttpClient createHttpClient() {
        return new RamlHttpClient(this.createTester());
    }

    public RamlHttpClient createHttpClient(CloseableHttpClient httpClient) {
        return new RamlHttpClient(this.createTester(), httpClient);
    }

    public RestAssuredClient createRestAssured() {
        return new RestAssuredClient(this.createTester());
    }

    public guru.nidi.ramltester.restassured3.RestAssuredClient createRestAssured3() {
        return new guru.nidi.ramltester.restassured3.RestAssuredClient(this.createTester());
    }

    public CheckingWebTarget createWebTarget(WebTarget target) {
        return new CheckingWebTarget(this.createTester(), target);
    }

    public RamlChecker createTester() {
        return new RamlChecker(this.config);
    }

    public RamlValidator validator() {
        return new RamlValidator(this.config.raml, this.config.schemaValidators);
    }

    public RamlReport validate() {
        return this.validator().validate();
    }
}

