/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.RamlValidatorChecker;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.core.Validation;
import java.util.List;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.Response;

public class RamlValidator {
    private final Raml raml;
    private final List<SchemaValidator> schemaValidators;
    private final Locator locator;
    private final RamlValidatorChecker checker;

    public RamlValidator(Raml raml, List<SchemaValidator> schemaValidators) {
        this(raml, schemaValidators, new RamlValidatorChecker(raml, schemaValidators));
    }

    private RamlValidator(Raml raml, List<SchemaValidator> schemaValidators, RamlValidatorChecker checker) {
        this.raml = raml;
        this.schemaValidators = schemaValidators;
        this.checker = checker;
        this.locator = checker.getLocator();
    }

    public RamlValidator withChecks(Validation ... validations) {
        return new RamlValidator(this.raml, this.schemaValidators, this.checker.withChecks(validations));
    }

    public RamlValidator withResourcePattern(String regex) {
        return new RamlValidator(this.raml, this.schemaValidators, this.checker.withResourcePattern(regex));
    }

    public RamlValidator withParameterPattern(String regex) {
        return new RamlValidator(this.raml, this.schemaValidators, this.checker.withParameterPattern(regex));
    }

    public RamlValidator withHeaderPattern(String regex) {
        return new RamlValidator(this.raml, this.schemaValidators, this.checker.withHeaderPattern(regex));
    }

    public RamlReport validate() {
        this.checker.parameters(this.raml.getBaseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.description(this.raml.getDocumentation());
        this.checker.description(this.raml.getBaseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        for (Resource resource : this.raml.getResources().values()) {
            this.resource(resource);
        }
        return this.checker.getReport();
    }

    private void resource(Resource resource) {
        this.locator.resource(resource);
        this.checker.resourcePattern(resource);
        this.checker.uriParameters(resource.getUriParameters().keySet(), resource);
        this.checker.parameters(resource.getBaseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.parameters(resource.getUriParameters(), RamlValidatorChecker.ParamName.URI);
        this.checker.description(resource.getDescription());
        this.checker.description(resource.getBaseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.description(resource.getUriParameters(), RamlValidatorChecker.ParamName.URI);
        this.checker.empty(resource);
        for (Resource res : resource.getResources().values()) {
            this.resource(res);
        }
        for (Action action : resource.getActions().values()) {
            this.action(action);
        }
    }

    private void action(Action action) {
        this.locator.action(action);
        this.checker.parameters(action.getBaseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.parameters(action.getQueryParameters(), RamlValidatorChecker.ParamName.QUERY);
        this.checker.headerPattern(action.getHeaders().keySet());
        this.checker.description(action.getDescription());
        this.checker.description(action.getBaseUriParameters(), RamlValidatorChecker.ParamName.BASE_URI);
        this.checker.description(action.getQueryParameters(), RamlValidatorChecker.ParamName.QUERY);
        this.checker.description(action.getHeaders(), RamlValidatorChecker.ParamName.HEADER);
        this.checker.empty(action);
        if (action.getBody() != null) {
            for (MimeType mimeType : action.getBody().values()) {
                this.locator.requestMime(mimeType);
                this.mimeType(mimeType);
            }
        }
        for (Map.Entry entry : action.getResponses().entrySet()) {
            this.locator.responseCode((String)entry.getKey());
            this.response((Response)entry.getValue());
        }
    }

    private void mimeType(MimeType mimeType) {
        if (mimeType.getFormParameters() != null) {
            this.checker.formParameters(mimeType);
            this.checker.parameters(mimeType.getFormParameters(), RamlValidatorChecker.ParamName.FORM);
            this.checker.description(mimeType.getFormParameters(), RamlValidatorChecker.ParamName.FORM);
        }
        this.checker.exampleSchema(mimeType);
    }

    private void response(Response response) {
        this.checker.headerPattern(response.getHeaders().keySet());
        this.checker.description(response.getDescription());
        this.checker.description(response.getHeaders(), RamlValidatorChecker.ParamName.HEADER);
        if (response.getBody() != null) {
            for (MimeType mimeType : response.getBody().values()) {
                this.locator.responseMime(mimeType);
                this.mimeType(mimeType);
            }
        }
    }
}

