/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.RamlViolationMessage;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SecurityExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.model.SecurityScheme;

class RamlViolationsPerSecurity {
    private static final Comparator<SecurityScheme> SCHEME_COMPARATOR = new Comparator<SecurityScheme>(){

        @Override
        public int compare(SecurityScheme s1, SecurityScheme s2) {
            return s1.getType().compareToIgnoreCase(s2.getType());
        }
    };
    private final List<SecurityScheme> schemes;
    private final Map<String, RamlViolations> requestViolations;
    private final Map<String, RamlViolations> responseViolations;

    public RamlViolationsPerSecurity(SecurityExtractor security) {
        this.schemes = new ArrayList<SecurityScheme>(security.getSchemes());
        Collections.sort(this.schemes, SCHEME_COMPARATOR);
        this.requestViolations = new HashMap<String, RamlViolations>();
        this.responseViolations = new HashMap<String, RamlViolations>();
        for (SecurityScheme scheme : this.schemes) {
            this.requestViolations.put(scheme.getType(), new RamlViolations());
            this.responseViolations.put(scheme.getType(), new RamlViolations());
        }
    }

    public RamlViolations requestViolations(SecurityScheme scheme) {
        return this.requestViolations.get(scheme.getType());
    }

    public RamlViolations responseViolations(SecurityScheme scheme) {
        return this.responseViolations.get(scheme.getType());
    }

    public List<SecurityScheme> leastViolations() {
        int best = Integer.MAX_VALUE;
        ArrayList<SecurityScheme> res = new ArrayList<SecurityScheme>();
        for (SecurityScheme scheme : this.schemes) {
            int violations = this.requestViolations(scheme).size() + this.responseViolations(scheme).size();
            if (violations > best) continue;
            if (violations < best) {
                res.clear();
            }
            res.add(scheme);
            best = violations;
        }
        return res;
    }

    public void addLeastViolations(RamlViolations request, RamlViolations response) {
        for (SecurityScheme scheme : this.leastViolations()) {
            this.addAll(scheme, this.requestViolations(scheme), request);
            this.addAll(scheme, this.responseViolations(scheme), response);
        }
    }

    private void addAll(SecurityScheme scheme, RamlViolations source, RamlViolations target) {
        if (this.schemes.size() == 1) {
            target.addAll(source);
        } else {
            for (RamlViolationMessage s : source) {
                target.add("scheme", scheme.getType(), s);
            }
        }
    }

    public String toString() {
        return "RamlViolationsPerSecurity{requestViolations=" + this.requestViolations + ", responseViolations=" + this.responseViolations + '}';
    }
}

