/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.Locator;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SecuritySchemeType;
import guru.nidi.ramltester.util.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.Raml;
import org.raml.model.Response;
import org.raml.model.SecurityReference;
import org.raml.model.SecurityScheme;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;

class SecurityExtractor {
    private final Raml raml;
    private final List<SecurityScheme> schemes;

    public SecurityExtractor(Raml raml, Action action, RamlViolations violations) {
        this.raml = raml;
        this.schemes = new SchemeFinder(raml, violations).securedBy(action);
    }

    public void check(RamlViolations violations) {
        for (Map schemeMap : this.raml.getSecuritySchemes()) {
            for (SecurityScheme scheme : schemeMap.values()) {
                SecuritySchemeType type = SecuritySchemeType.byName(scheme.getType());
                if (type == null) continue;
                type.check(scheme, violations);
            }
        }
    }

    public List<SecurityScheme> getSchemes() {
        return this.schemes;
    }

    public Map<String, QueryParameter> queryParameters(SecurityScheme scheme) {
        return scheme.getDescribedBy() == null ? Collections.emptyMap() : scheme.getDescribedBy().getQueryParameters();
    }

    public Map<String, Header> headers(SecurityScheme scheme) {
        return scheme.getDescribedBy() == null ? Collections.emptyMap() : scheme.getDescribedBy().getHeaders();
    }

    public Map<String, Response> responses(SecurityScheme scheme) {
        return scheme.getDescribedBy() == null ? Collections.emptyMap() : scheme.getDescribedBy().getResponses();
    }

    private static final class SchemeFinder {
        private static final SecurityScheme NULL_SCHEMA = new SecurityScheme();
        private final Raml raml;
        private final RamlViolations violations;

        public SchemeFinder(Raml raml, RamlViolations violations) {
            this.raml = raml;
            this.violations = violations;
        }

        public List<SecurityScheme> securedBy(Action action) {
            ArrayList<SecurityScheme> res = new ArrayList<SecurityScheme>();
            if (!action.getSecuredBy().isEmpty()) {
                res.addAll(this.securitySchemes(action.getSecuredBy(), new Message("securityScheme.undefined", new Locator(action))));
            } else if (!action.getResource().getSecuredBy().isEmpty()) {
                res.addAll(this.securitySchemes(action.getResource().getSecuredBy(), new Message("securityScheme.undefined", new Locator(action.getResource()))));
            } else if (!this.raml.getSecuredBy().isEmpty()) {
                res.addAll(this.securitySchemes(this.raml.getSecuredBy(), new Message("securityScheme.undefined", new Locator())));
            }
            if (res.isEmpty()) {
                res.add(NULL_SCHEMA);
            }
            return res;
        }

        private List<SecurityScheme> securitySchemes(List<SecurityReference> refs, Message message) {
            ArrayList<SecurityScheme> res = new ArrayList<SecurityScheme>();
            for (SecurityReference ref : refs) {
                String name = ref.getName();
                if ("null".equals(name)) {
                    res.add(NULL_SCHEMA);
                    continue;
                }
                SecurityScheme ss = this.securityScheme(name);
                if (ss == null) {
                    this.violations.add(message.withParam(name));
                    continue;
                }
                res.add(ss);
            }
            return res;
        }

        private SecurityScheme securityScheme(String name) {
            for (Map map : this.raml.getSecuritySchemes()) {
                if (!map.containsKey(name)) continue;
                return (SecurityScheme)map.get(name);
            }
            return null;
        }

        static {
            NULL_SCHEMA.setType("null");
        }
    }
}

