/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.restassured3;

import guru.nidi.ramltester.core.RamlChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportStore;
import guru.nidi.ramltester.core.ThreadLocalReportStore;
import guru.nidi.ramltester.restassured3.RestAssuredRamlRequest;
import guru.nidi.ramltester.restassured3.RestAssuredRamlResponse;
import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;

public class RamlValidationFilter
implements Filter {
    private final RamlChecker ramlChecker;
    private final ReportStore reportStore;

    public RamlValidationFilter(RamlChecker ramlChecker) {
        this.ramlChecker = ramlChecker;
        this.reportStore = new ThreadLocalReportStore();
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext filterContext) {
        Response response = filterContext.next(requestSpec, responseSpec);
        RamlReport report = this.ramlChecker.check(new RestAssuredRamlRequest(requestSpec), new RestAssuredRamlResponse(response));
        this.reportStore.storeReport(report);
        return response;
    }

    public ReportStore getReportStore() {
        return this.reportStore;
    }
}

