/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class IoUtils {
    private IoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readIntoString(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[1000];
            while (reader.ready()) {
                int read = reader.read(buf);
                sb.append(buf, 0, read);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] readIntoByteArray(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        try {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int read;
                byte[] buf = new byte[1000];
                while ((read = in.read(buf)) > 0) {
                    out.write(buf, 0, read);
                }
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            in.close();
        }
    }
}

