/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.validator;

import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfigurationBuilder;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import guru.nidi.loader.Loader;
import guru.nidi.loader.use.jsonschema.LoaderUriDownloader;
import guru.nidi.ramltester.core.JsonSchemaViolationCause;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.io.IOException;
import java.io.Reader;

public class JsonSchemaValidator
implements SchemaValidator {
    private JsonSchemaFactory factory;
    private final Loader loader;

    private JsonSchemaValidator(JsonSchemaFactory factory, Loader loader) {
        this.factory = factory;
        this.loader = loader;
    }

    public JsonSchemaValidator() {
        this(null, null);
    }

    public JsonSchemaValidator using(JsonSchemaFactory factory) {
        return new JsonSchemaValidator(factory, this.loader);
    }

    @Override
    public SchemaValidator withLoader(Loader loader) {
        return new JsonSchemaValidator(this.factory, loader);
    }

    @Override
    public boolean supports(MediaType mediaType) {
        return mediaType.isCompatibleWith(MediaType.JSON);
    }

    private synchronized void init() {
        if (this.loader != null && this.factory == null) {
            LoadingConfigurationBuilder loadingConfig = LoadingConfiguration.newBuilder();
            String simpleName = this.loader.getClass().getSimpleName();
            loadingConfig.addScheme(simpleName, (URIDownloader)new LoaderUriDownloader(this.loader));
            loadingConfig.setURITranslatorConfiguration(URITranslatorConfiguration.newBuilder().setNamespace(simpleName + ":///").freeze());
            this.factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(loadingConfig.freeze()).freeze();
        }
    }

    @Override
    public void validate(Reader content, Reader schema, RamlViolations violations, Message message) {
        this.init();
        try (Reader s = schema;){
            JsonSchemaFactory factory = this.factory == null ? JsonSchemaFactory.byDefault() : this.factory;
            JsonSchema jsonSchema = factory.getJsonSchema(JsonLoader.fromReader((Reader)schema));
            ProcessingReport report = jsonSchema.validate(JsonLoader.fromReader((Reader)content));
            if (!report.isSuccess()) {
                String msg = "";
                for (ProcessingMessage reportLine : report) {
                    msg = msg + new Message("jsonSchemaValidator.message", reportLine.toString());
                }
                violations.add(message.withParam(msg), (Object)new JsonSchemaViolationCause(report));
            }
        }
        catch (ProcessingException e) {
            violations.add(message.withMessageParam("schema.invalid", e.getMessage()), (Object)new JsonSchemaViolationCause(e));
        }
        catch (IOException e) {
            violations.add(message.withMessageParam("schema.invalid", e.getMessage()));
        }
    }
}

