/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class CountSet<T>
extends AbstractSet<T> {
    private final Map<T, Integer> map = new HashMap<T, Integer>();

    CountSet() {
    }

    public void add(T value, int count) {
        int old = this.getCount(value);
        this.map.put(value, old + count);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean add(T value) {
        this.add(value, 1);
        return true;
    }

    public void addAll(Collection<? extends T> values, int count) {
        for (T value : values) {
            this.add(value, count);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> values) {
        this.addAll(values, 1);
        return true;
    }

    public int getCount(T value) {
        Integer count = this.map.get(value);
        return count == null ? 0 : count;
    }

    public Iterable<Map.Entry<T, Integer>> values() {
        return new Iterable<Map.Entry<T, Integer>>(){

            @Override
            public Iterator<Map.Entry<T, Integer>> iterator() {
                return CountSet.this.map.entrySet().iterator();
            }
        };
    }

    @Override
    public String toString() {
        return this.map.toString();
    }
}

