/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

final class JsRegex {
    private static final String MATCHES_IN_JS = "var matches = function(input, re, flags){    var r = flags ? new RegExp(re,flags) : new RegExp(re);    return r.test(input);};";
    private static final ScriptEngine ENGINE;

    private JsRegex() {
    }

    public static boolean matches(String input, String regex) {
        int pos;
        String unquoted;
        String string = unquoted = JsRegex.isDoubleQuoted(regex) || JsRegex.isSingleQuoted(regex) ? regex.substring(1, regex.length() - 1) : regex;
        if (unquoted.startsWith("/") && (pos = unquoted.lastIndexOf(47)) >= unquoted.length() - 3) {
            String flags = pos == unquoted.length() - 1 ? "" : unquoted.substring(pos + 1);
            String unslashed = unquoted.substring(1, pos).replace("\\/", "/");
            return JsRegex.matches(input, unslashed, flags);
        }
        return JsRegex.matches(input, unquoted, null);
    }

    public static boolean matches(String input, String regex, String flags) {
        try {
            return (Boolean)((Invocable)((Object)ENGINE)).invokeFunction("matches", input, regex, flags);
        }
        catch (Exception e) {
            Throwable t = e;
            while (t.getMessage() == null && t.getCause() != null) {
                t = t.getCause();
            }
            throw new InvalidRegexException(t.getMessage(), t);
        }
    }

    private static boolean isDoubleQuoted(String regex) {
        return regex.startsWith("\"") && regex.endsWith("\"");
    }

    private static boolean isSingleQuoted(String regex) {
        return regex.startsWith("'") && regex.endsWith("'");
    }

    static {
        try {
            ENGINE = new ScriptEngineManager().getEngineByExtension("js");
            ENGINE.eval(MATCHES_IN_JS);
        }
        catch (ScriptException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static class InvalidRegexException
    extends RuntimeException {
        public InvalidRegexException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

