/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.Usage;
import java.util.List;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.Response;

public final class UsageBuilder {
    private UsageBuilder() {
    }

    static Usage.Resource resourceUsage(Usage usage, Resource resource) {
        return usage.resource(resource.getUri());
    }

    static Usage.Action actionUsage(Usage usage, Action action) {
        return usage.resource(action.getResource().getUri()).action(action.getType().name());
    }

    static Usage.Response responseUsage(Usage usage, Action action, String responseCode) {
        return UsageBuilder.actionUsage(usage, action).response(responseCode);
    }

    static Usage.MimeType mimeTypeUsage(Usage usage, Action action, MimeType mimeType) {
        return UsageBuilder.actionUsage(usage, action).mimeType(mimeType.getType());
    }

    public static Usage usage(Raml raml, List<RamlReport> reports) {
        Usage usage = new Usage();
        UsageBuilder.createTotalUsage(usage, raml.getResources());
        for (RamlReport report : reports) {
            usage.add(report.getUsage());
        }
        return usage;
    }

    private static void createTotalUsage(Usage usage, Map<String, Resource> resources) {
        for (Map.Entry<String, Resource> resourceEntry : resources.entrySet()) {
            UsageBuilder.resourceUsage(usage, resourceEntry.getValue());
            for (Action action : resourceEntry.getValue().getActions().values()) {
                UsageBuilder.actionUsage(usage, action).initQueryParameters(action.getQueryParameters().keySet());
                UsageBuilder.actionUsage(usage, action).initResponseCodes(action.getResponses().keySet());
                UsageBuilder.actionUsage(usage, action).initRequestHeaders(action.getHeaders().keySet());
                if (action.getBody() != null) {
                    for (MimeType mimeType : action.getBody().values()) {
                        if (mimeType.getFormParameters() == null) continue;
                        UsageBuilder.mimeTypeUsage(usage, action, mimeType).initFormParameters(mimeType.getFormParameters().keySet());
                    }
                }
                for (Map.Entry entry : action.getResponses().entrySet()) {
                    UsageBuilder.responseUsage(usage, action, (String)entry.getKey()).initResponseHeaders(((Response)entry.getValue()).getHeaders().keySet());
                }
            }
            UsageBuilder.createTotalUsage(usage, resourceEntry.getValue().getResources());
        }
    }
}

