/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import guru.nidi.ramltester.core.IllegalVariablePatternException;
import guru.nidi.ramltester.model.Values;

final class VariableMatcher {
    private final boolean matches;
    private final boolean completeMatch;
    private final String suffix;
    private final Values variables;

    private VariableMatcher(boolean matches, boolean completeMatch, String suffix, Values variables) {
        this.matches = matches;
        this.completeMatch = completeMatch;
        this.suffix = suffix;
        this.variables = variables;
    }

    public static VariableMatcher match(String pattern, String value) {
        Values variables = new Values();
        int patternPos = 0;
        int valuePos = 0;
        while (patternPos < pattern.length() && valuePos < value.length()) {
            if (pattern.charAt(patternPos) == '{') {
                StringBuilder varName = new StringBuilder();
                ++patternPos;
                while (patternPos < pattern.length() && pattern.charAt(patternPos) != '}') {
                    varName.append(pattern.charAt(patternPos));
                    ++patternPos;
                }
                if (patternPos == pattern.length() && pattern.charAt(patternPos - 1) != '}') {
                    throw new IllegalVariablePatternException("Unclosed variable " + varName, pattern);
                }
                char next = ++patternPos < pattern.length() ? (char)pattern.charAt(patternPos) : (char)'/';
                StringBuilder varValue = new StringBuilder();
                while (valuePos < value.length() && value.charAt(valuePos) != next) {
                    varValue.append(value.charAt(valuePos));
                    ++valuePos;
                }
                variables.addValue(varName.toString(), varValue.toString());
                continue;
            }
            if (pattern.charAt(patternPos) != value.charAt(valuePos)) {
                return new VariableMatcher(false, false, "", new Values());
            }
            ++patternPos;
            ++valuePos;
        }
        boolean match = patternPos == pattern.length();
        return new VariableMatcher(match, match && valuePos == value.length(), value.substring(valuePos), variables);
    }

    public boolean isMatch() {
        return this.matches;
    }

    public boolean isCompleteMatch() {
        return this.completeMatch;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Values getVariables() {
        return this.variables;
    }
}

