/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.httpcomponents;

import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.util.IoUtils;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.entity.BufferedHttpEntity;

class HttpComponentsRamlMessage {
    HttpComponentsRamlMessage() {
    }

    protected String contentTypeOf(HttpMessage message) {
        Header contentType = message.getFirstHeader("Content-Type");
        return contentType == null ? null : contentType.getValue();
    }

    protected Values headerValuesOf(HttpMessage message) {
        Values headers = new Values();
        for (Header header : message.getAllHeaders()) {
            headers.addValue(header.getName(), header.getValue());
        }
        return headers;
    }

    protected HttpResponse buffered(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        if (entity != null && !entity.isRepeatable()) {
            response.setEntity((HttpEntity)this.buffered(entity));
        }
        return response;
    }

    protected HttpEntityEnclosingRequest buffered(HttpEntityEnclosingRequest request) {
        HttpEntity entity = request.getEntity();
        if (entity != null && !entity.isRepeatable()) {
            request.setEntity((HttpEntity)this.buffered(entity));
        }
        return request;
    }

    private BufferedHttpEntity buffered(HttpEntity entity) {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (IOException e) {
            throw new RamlCheckerException("Could not read content of entity", e);
        }
    }

    protected byte[] contentOf(HttpEntity entity) {
        try {
            return entity == null ? null : IoUtils.readIntoByteArray(entity.getContent());
        }
        catch (IOException e) {
            throw new RamlCheckerException("Could not get response content", e);
        }
    }
}

